/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;

public class UUIDHandler
extends SingleColumnHandler<UUID> {
    @Override
    public void activated() {
        super.activated();
        if (this.getOrmContext().getLength() == null) {
            this.getOrmContext().setLength(UUID.randomUUID().toString().length());
        }
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return 1;
    }

    @Override
    public void mapColumnValueToPreparedStatement(UUID uUID, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, uUID.toString());
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(UUID.class);
    }

    @Override
    public void loadProperty(WProperty<UUID> wProperty, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        UUID uUID = string != null ? UUID.fromString(string) : null;
        wProperty.set(uUID);
    }

    @Override
    public void setColumn(ColumnContext columnContext) {
        super.setColumn(columnContext);
        columnContext.setLength(36L);
    }
}

