/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.OrmPropertyContext;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.handlers.BigDecimalHandler;
import net.java.dev.properties.jdbc.handlers.BooleanHandler;
import net.java.dev.properties.jdbc.handlers.ByteHandler;
import net.java.dev.properties.jdbc.handlers.CharacterHandler;
import net.java.dev.properties.jdbc.handlers.CloneableTypeHandler;
import net.java.dev.properties.jdbc.handlers.ColorHandler;
import net.java.dev.properties.jdbc.handlers.ComponentHandler;
import net.java.dev.properties.jdbc.handlers.DateOnlyHandler;
import net.java.dev.properties.jdbc.handlers.DateTimeHandler;
import net.java.dev.properties.jdbc.handlers.DefaultTypeHandler;
import net.java.dev.properties.jdbc.handlers.DoubleHandler;
import net.java.dev.properties.jdbc.handlers.FloatHandler;
import net.java.dev.properties.jdbc.handlers.IntegerHandler;
import net.java.dev.properties.jdbc.handlers.JavaDotSqlDotDateHandler;
import net.java.dev.properties.jdbc.handlers.JavaDotSqlDotTimeHandler;
import net.java.dev.properties.jdbc.handlers.JavaDotSqlDotTimestampHandler;
import net.java.dev.properties.jdbc.handlers.JavaDotUtilDotDateHandler;
import net.java.dev.properties.jdbc.handlers.LifecycleAwareTypeHandler;
import net.java.dev.properties.jdbc.handlers.LongHandler;
import net.java.dev.properties.jdbc.handlers.ManyEntityHandler;
import net.java.dev.properties.jdbc.handlers.ObjectToStringHandler;
import net.java.dev.properties.jdbc.handlers.ShortHandler;
import net.java.dev.properties.jdbc.handlers.StringHandler;
import net.java.dev.properties.jdbc.handlers.TimeOnlyHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.java.dev.properties.jdbc.handlers.UUIDHandler;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class TypeHandlerFactory {
    private static final Logger logger = LoggerHelper.getLogger();
    private List<TypeHandler<?>> _typeSpecificHandlers = ListX.create();
    private List<TypeHandler<?>> _genericHandlers = ListX.create();
    private List<TypeHandler<?>> _combinedHandlers;
    private final Map<Class, TypeHandler> _resolvedHandlers = Collections.synchronizedMap(new HashMap());
    private SessionConfiguration _sessionConfiguration;
    private Injector _injector;

    @Inject
    public TypeHandlerFactory(Injector injector, SessionConfiguration sessionConfiguration) {
        this._sessionConfiguration = sessionConfiguration;
        this._injector = injector;
        this.initDefaultHandlers();
    }

    private void initDefaultHandlers() {
        this.addTypeSpecific(ColorHandler.class);
        this.addTypeSpecific(BigDecimalHandler.class);
        this.addTypeSpecific(BooleanHandler.class);
        this.addTypeSpecific(ByteHandler.class);
        this.addTypeSpecific(CharacterHandler.class);
        this.addTypeSpecific(DoubleHandler.class);
        this.addTypeSpecific(FloatHandler.class);
        this.addTypeSpecific(IntegerHandler.class);
        this.addTypeSpecific(JavaDotUtilDotDateHandler.class);
        this.addTypeSpecific(JavaDotSqlDotDateHandler.class);
        this.addTypeSpecific(JavaDotSqlDotTimeHandler.class);
        this.addTypeSpecific(JavaDotSqlDotTimestampHandler.class);
        this.addTypeSpecific(LongHandler.class);
        this.addTypeSpecific(UUIDHandler.class);
        this.addTypeSpecific(ShortHandler.class);
        this.addTypeSpecific(StringHandler.class);
        this.addTypeSpecific(TimeOnlyHandler.class);
        this.addTypeSpecific(DateOnlyHandler.class);
        this.addTypeSpecific(DateTimeHandler.class);
        this.addGeneric(ObjectToStringHandler.class);
    }

    public SessionConfiguration getSessionConfiguration() {
        return this._sessionConfiguration;
    }

    public <T extends TypeHandler<?>> void addTypeSpecific(Class<T> clazz) {
        T t = this.newTypeHandler(clazz);
        this.addTypeSpecific((TypeHandler)t);
    }

    public void setHandler(Class<?> clazz, TypeHandler<?> typeHandler) {
        this._resolvedHandlers.put(clazz, typeHandler);
    }

    public void addTypeSpecific(TypeHandler typeHandler) {
        this._typeSpecificHandlers.add(typeHandler);
        this._combinedHandlers = null;
    }

    public <T extends TypeHandler<?>> void addGeneric(Class<T> clazz) {
        T t = this.newTypeHandler(clazz);
        this.addGeneric((TypeHandler)t);
    }

    public void addGeneric(TypeHandler typeHandler) {
        this._genericHandlers.add(typeHandler);
        this._combinedHandlers = null;
    }

    public <T> TypeHandler<T> createHandlerForPropertyContext(EntityPersister entityPersister, IPropertyContext iPropertyContext) {
        Object object;
        Class<?> clazz = iPropertyContext.getType();
        Class<?> clazz2 = iPropertyContext.getReflector().getPropertyType();
        TypeHandler<Object> typeHandler = this._resolvedHandlers.get(clazz);
        IBeanContext iBeanContext = BeanContainer.get().getContext(clazz);
        OrmPropertyContext ormPropertyContext = iPropertyContext.getOrmContext();
        if (ormPropertyContext.getTypeHandler() != null) {
            typeHandler = this.newTypeHandler(ormPropertyContext.getTypeHandler());
        } else if (iPropertyContext.isIndexedProperty()) {
            typeHandler = new ManyEntityHandler();
        } else if (typeHandler == null) {
            for (TypeHandler<?> typeHandler2 : this.getHandlers()) {
                if (!typeHandler2.canHandleType(clazz)) continue;
                this._resolvedHandlers.put(clazz, typeHandler2);
                typeHandler = typeHandler2;
                break;
            }
            if (typeHandler == null) {
                object = clazz.getAnnotation(Column.class);
                if (object != null && !object.typeHandler().equals(TypeHandler.class)) {
                    typeHandler = this.newTypeHandler(object.typeHandler());
                }
                if (!Enum.class.isAssignableFrom(clazz) && !Number.class.isAssignableFrom(clazz) && iBeanContext != null && iBeanContext.getTypeHandler() != null) {
                    typeHandler = this.newTypeHandler(iBeanContext.getTypeHandler());
                }
                if (typeHandler == null) {
                    typeHandler = this.getDefaultTypeHandler(clazz);
                }
            }
        }
        if (typeHandler == null && iBeanContext.isComponent()) {
            typeHandler = new ComponentHandler();
        }
        if (typeHandler == null) {
            throw new RuntimeException("no handler found for " + clazz.getName());
        }
        if ((typeHandler = typeHandler instanceof CloneableTypeHandler ? ((CloneableTypeHandler)typeHandler).clone() : this.newTypeHandler(typeHandler.getClass())) instanceof LifecycleAwareTypeHandler) {
            object = typeHandler;
            object.setPropertyContext(iPropertyContext);
            object.setHandlerFactory(this);
            object.setParentEntityPersister(entityPersister);
            object.activated();
        }
        return typeHandler;
    }

    public <T> TypeHandler<T> createHandlerForType(Class clazz) {
        TypeHandler<Object> typeHandler = this._resolvedHandlers.get(clazz);
        if (typeHandler == null) {
            for (TypeHandler<?> typeHandler2 : this.getHandlers()) {
                if (!typeHandler2.canHandleType(clazz)) continue;
                this._resolvedHandlers.put(clazz, typeHandler2);
                typeHandler = typeHandler2;
                break;
            }
            if (typeHandler == null) {
                TypeHandler<?> typeHandler2;
                Column column = clazz.getAnnotation(Column.class);
                if (column != null && !column.typeHandler().equals(TypeHandler.class)) {
                    typeHandler = this.newTypeHandler(column.typeHandler());
                }
                if (!Enum.class.isAssignableFrom(clazz) && !Number.class.isAssignableFrom(clazz) && (typeHandler2 = BeanContainer.get().getContext(clazz)) != null && typeHandler2.getTypeHandler() != null) {
                    typeHandler = this.newTypeHandler(typeHandler2.getTypeHandler());
                }
                if (typeHandler == null) {
                    typeHandler = this.getDefaultTypeHandler(clazz);
                }
            }
        }
        if (typeHandler == null) {
            throw new RuntimeException("no handler found for " + clazz.getName());
        }
        typeHandler = typeHandler instanceof CloneableTypeHandler ? ((CloneableTypeHandler)typeHandler).clone() : this.newTypeHandler(typeHandler.getClass());
        return typeHandler;
    }

    TypeHandler getDefaultTypeHandler(Class<?> clazz) {
        DefaultTypeHandler defaultTypeHandler = clazz.getAnnotation(DefaultTypeHandler.class);
        if (defaultTypeHandler != null) {
            return this.newTypeHandler(defaultTypeHandler.value());
        }
        if (clazz.getSuperclass() != null) {
            return this.getDefaultTypeHandler(clazz.getSuperclass());
        }
        return null;
    }

    <T extends TypeHandler<?>> T newTypeHandler(Class<T> clazz) {
        try {
            if (clazz != null) {
                return (T)((TypeHandler)this._injector.getInstance(clazz));
            }
        }
        catch (Exception exception) {
            logger.error((Object)"error creating type handler {}", clazz, (Object)exception);
        }
        return null;
    }

    public List<TypeHandler<?>> getHandlers() {
        if (this._combinedHandlers == null) {
            List list = ListX.create();
            list.addAll(this._typeSpecificHandlers);
            list.addAll(this._genericHandlers);
            this._combinedHandlers = list;
        }
        return this._combinedHandlers;
    }

    public void remove(TypeHandler<?> typeHandler) {
        this._combinedHandlers = null;
        this._genericHandlers.remove(typeHandler);
        this._typeSpecificHandlers.remove(typeHandler);
    }
}

