/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.chrono.TimeOnly;

public class TimeOnlyHandler
extends SingleColumnHandler<TimeOnly> {
    @Override
    public Integer getSqlTypeAsInteger() {
        return 92;
    }

    @Override
    public void mapColumnValueToPreparedStatement(TimeOnly timeOnly, PreparedStatement preparedStatement, int n) throws SQLException {
        Time time = null;
        if (timeOnly != null) {
            time = new Time(timeOnly.getHour(), timeOnly.getMinutes(), timeOnly.getSeconds());
        }
        preparedStatement.setTime(n, time);
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(TimeOnly.class);
    }

    @Override
    public void loadProperty(WProperty<TimeOnly> wProperty, ResultSet resultSet, int n) throws SQLException {
        Time time = resultSet.getTime(n);
        TimeOnly timeOnly = null;
        if (time != null) {
            timeOnly = new TimeOnly(time);
        }
        wProperty.set(timeOnly);
    }
}

