/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.AbstractLazyLoaderPropertyListener;
import net.java.dev.properties.jdbc.CascadeHandler;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.PersistenceStrategy;
import net.java.dev.properties.jdbc.handlers.AbstractTypeHandler;
import net.java.dev.properties.jdbc.handlers.CloneableTypeHandler;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.TypeHandler;

public class SingleEntityHandler<T>
extends AbstractTypeHandler<T>
implements CloneableTypeHandler<T>,
CascadeHandler {
    private EntityPersister<T> _foreignPersister;
    private PersistenceStrategy _persistenceStrategy;

    public SingleEntityHandler(EntityPersister<T> entityPersister) {
        this._foreignPersister = entityPersister;
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return this._foreignPersister.getBeanClass().equals(clazz);
    }

    @Override
    public void activated() {
        this.setColumns(new ArrayList<ColumnContext>());
        if (this._foreignPersister == null) {
            this._foreignPersister = this.getSessionConfiguration().getPersister(this.getPropertyContext().getType());
        }
        IPropertyContext iPropertyContext = this.getPropertyContext();
        List<TypeHandler<Object>> list = this.getForeignPersister().getPrimaryKeyHandlers();
        if (list.size() == 1 && list.get(0).getColumns().size() == 1) {
            TypeHandler<Object> typeHandler = list.get(0);
            ColumnContext columnContext = typeHandler.getColumns().get(0);
            ColumnContext columnContext2 = this.createColumnContext(this.getOrmContext().getColumnName(), columnContext, this.getOrmContext().isPrimaryKey(), 0);
            this.getColumns().add(columnContext2);
        } else {
            String string = this.getPropertyContext().getName();
            String[] stringArray = this.getOrmContext().getColumnNames();
            boolean bl = true;
            if (this.getForeignPersister().getPrimaryKeyHandlers().size() > 1 && stringArray.length == 1 && stringArray[0].equals(this.getPropertyContext().getName())) {
                bl = false;
            }
            int n = 0;
            for (TypeHandler<Object> typeHandler : this.getForeignPersister().getPrimaryKeyHandlers()) {
                for (ColumnContext columnContext : typeHandler.getColumns()) {
                    String string2 = null;
                    if (n < stringArray.length) {
                        string2 = stringArray[n];
                    }
                    if (!bl || string2 == null || string2.trim().length() == 0) {
                        string2 = string + "_" + columnContext.getName();
                    }
                    ColumnContext columnContext3 = this.createColumnContext(string2, columnContext, this.getOrmContext().isPrimaryKey(), n);
                    this.getColumns().add(columnContext3);
                    ++n;
                }
            }
        }
        super.activated();
        this._persistenceStrategy = this.getSessionConfiguration().getPersistenceStrategy();
    }

    @Override
    public Object getColumnValue(Object object, int n) {
        Object object2 = super.getColumnValue(object, n);
        List<ColumnContext> list = this.getForeignPersister().getPrimaryKeyColumns();
        ColumnContext columnContext = list.get(n);
        TypeHandler typeHandler = columnContext.getTypeHandler();
        return typeHandler.getColumnValue(object2, columnContext.getColumnIndexInTypeHandler());
    }

    public EntityPersister<T> getForeignPersister() {
        return this._foreignPersister;
    }

    @Override
    public void mapColumnToPreparedStatement(Object object, int n, PreparedStatement preparedStatement, int n2) throws SQLException {
        ColumnContext columnContext = this.getForeignPersister().getPrimaryKeyColumns().get(n);
        columnContext.getTypeHandler().mapColumnToPreparedStatement(object, columnContext.getColumnIndexInTypeHandler(), preparedStatement, n2);
    }

    @Override
    public void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        int n2 = 0;
        SimpleProperty simpleProperty = new SimpleProperty();
        Object[] objectArray = new Object[this.getForeignPersister().getPrimaryKeyColumns().size()];
        objectArray.toString();
        for (TypeHandler<Object> typeHandler : this.getForeignPersister().getPrimaryKeyHandlers()) {
            simpleProperty.setValueSet(false);
            typeHandler.loadProperty(simpleProperty, resultSet, n + n2);
            if (simpleProperty.valueSet) {
                objectArray[n2] = simpleProperty.get();
            } else {
                Object[] objectArray2 = simpleProperty.getPrimaryKeyValues();
                System.arraycopy(objectArray2, 0, objectArray, n2, objectArray2.length);
            }
            n2 += typeHandler.getColumns().size();
        }
        if (wProperty instanceof SimpleProperty) {
            ((SimpleProperty)wProperty).setPrimaryKeyValues(objectArray);
        } else if (wProperty.getContext() != null) {
            new AbstractLazyLoaderPropertyListener(wProperty, objectArray){

                @Override
                public void onGetImpl(RProperty<?> rProperty) {
                    InternalSession internalSession = (InternalSession)CurrentSession.get();
                    internalSession.pushDirtyCheckingSuspension();
                    ((WProperty)((Object)rProperty)).set(CurrentSession.get().fetchByPK(rProperty.getContext().getType(), this.getPrimaryKeyValues()));
                    internalSession.popDirtyCheckingSuspension();
                }
            };
        }
    }

    @Override
    public SingleEntityHandler<T> clone() {
        return new SingleEntityHandler<T>(this.getForeignPersister());
    }

    @Override
    public void processCascade(InternalSession internalSession, Object object) {
        Object t = this.getPropertyContext().getValue(object);
        if (t != null && !this._persistenceStrategy.isPersisted(internalSession, t)) {
            internalSession.insert(t);
        }
    }

    public boolean needsMerging() {
        return true;
    }

    static class SimpleProperty
    implements WProperty<Object>,
    RProperty<Object> {
        Object value;
        Object[] primaryKeyValues;
        boolean valueSet;

        SimpleProperty() {
        }

        @Override
        public void set(Object object) {
            this.valueSet = true;
            this.value = object;
        }

        public void setValueSet(boolean bl) {
            this.valueSet = bl;
        }

        @Override
        public Object get() {
            return this.value;
        }

        @Override
        public IPropertyContext getContext() {
            return null;
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        public void setContext(IPropertyContext iPropertyContext) {
        }

        @Override
        public void setParent(Object object) {
        }

        public void setPrimaryKeyValues(Object ... objectArray) {
            this.primaryKeyValues = objectArray;
        }

        public Object[] getPrimaryKeyValues() {
            return this.primaryKeyValues;
        }
    }
}

