/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.java.dev.properties.util.Utils;

public abstract class PrimitiveTypeHandler<T>
extends SingleColumnHandler<T> {
    private Class _primitiveType;
    private Class _referenceType;
    private Integer _primitiveSqlType;

    protected PrimitiveTypeHandler(Class clazz, Integer n) {
        this._primitiveSqlType = n;
        if (clazz.isPrimitive()) {
            this._primitiveType = clazz;
            this._referenceType = Utils.getNonPrimitive(clazz);
        } else {
            this._primitiveType = Utils.getPrimitive(clazz);
            this._referenceType = clazz;
        }
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return this._primitiveSqlType;
    }

    public abstract T get(ResultSet var1, int var2) throws SQLException;

    @Override
    public final void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        wProperty.set(this.get(resultSet, n));
    }

    @Override
    public void mapColumnValueToPreparedStatement(T object, PreparedStatement preparedStatement, int n) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, this.getSqlType().getSqlType());
        } else {
            if (this.getPropertyContext() != null && Number.class.isAssignableFrom(this.getPropertyContext().getType())) {
                object = Utils.normalizeType((Number)object, this.getPropertyContext().getType());
            }
            this.mapNonNullPrimitiveToPreparedStatement(object, preparedStatement, n);
        }
    }

    public abstract void mapNonNullPrimitiveToPreparedStatement(T var1, PreparedStatement var2, int var3) throws SQLException;

    @Override
    public boolean canHandleType(Class clazz) {
        return clazz.equals(this._primitiveType) || clazz.equals(this._referenceType);
    }
}

