/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import com.google.inject.Inject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.bean.ConverterFactory;
import net.model3.bean.converters.Converter;
import net.model3.lang.ClassX;

public class ObjectToStringHandler<T>
extends SingleColumnHandler<T> {
    Converter<T> _converter;
    @Inject
    ConverterFactory _converterFactory;

    public T convertStringToObject(String string) {
        return (T)this._converter.stringToValue(this.getPropertyContext().getType(), string);
    }

    public String convertObjectToString(T t) {
        return this._converter.valueToString(t);
    }

    @Override
    public void activated() {
        super.activated();
        if (this._converter == null) {
            this._converter = this instanceof Converter ? (Converter)this : this._converterFactory.getConverter(this.getPropertyContext().getType(), true);
        }
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        Class clazz2 = ClassX.getParameterizedType(this.getClass());
        if (clazz2 != null) {
            return ClassX.isAssignable((Class)clazz2, clazz);
        }
        return null != this._converterFactory.getConverter(clazz);
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return this.getSessionConfiguration().getSqlDialect().getDefaultStringType().getSqlType();
    }

    @Override
    public void mapColumnValueToPreparedStatement(T t, PreparedStatement preparedStatement, int n) throws SQLException {
        String string = this.convertObjectToString(t);
        preparedStatement.setString(n, string);
    }

    @Override
    public void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        T t = this.convertStringToObject(string);
        wProperty.set(t);
    }

    public void setConverter(Converter<T> converter) {
        this._converter = converter;
    }
}

