/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.annotations.ManyToMany;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.events.IndexedPropertyListener;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.AbstractLazyLoaderPropertyListener;
import net.java.dev.properties.jdbc.BatchUpdateQuery;
import net.java.dev.properties.jdbc.CascadeHandler;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.LazyLoader;
import net.java.dev.properties.jdbc.QueryStringBuilder;
import net.java.dev.properties.jdbc.SelectQuery;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionAware;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.dialect.SQLDialect;
import net.java.dev.properties.jdbc.handlers.AbstractTypeHandler;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.ManyHandlerInterface;
import net.java.dev.properties.jdbc.handlers.TableCreator;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public class ManyToManyHandler<T>
extends AbstractTypeHandler<T>
implements ManyHandlerInterface<T>,
TableCreator,
CascadeHandler {
    private final Logger logger = BeanPropsLoggerHelper.getLogger();
    private String _insertQuery;
    private String _deleteQuery;
    private String _tableName;
    private String[] _localKeyColumnNames;
    private String[] _foreignKeyColumnNames;
    private EntityPersister<T> _foreignEntityPersister;
    private boolean _transientSide;

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public void mapColumnToPreparedStatement(Object object, int n, PreparedStatement preparedStatement, int n2) throws SQLException {
    }

    @Override
    public Object getColumnValue(Object object, int n) {
        return super.getColumnValue(object, n);
    }

    @Override
    public void loadProperty(final WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        if (!(wProperty instanceof OnGetListener)) {
            throw new RuntimeException("properties must support an OnGetListener");
        }
        final OnGetListener onGetListener = (OnGetListener)((Object)wProperty);
        onGetListener.setOnGet(new AbstractLazyLoaderPropertyListener(wProperty){

            @Override
            public Object[] getPrimaryKeyValues() {
                return ManyToManyHandler.this.getParentEntityPersister().getPrimaryKeyColumnValues(wProperty.getParent());
            }

            @Override
            public void onGetImpl(RProperty<?> rProperty) {
                WProperty wProperty2 = (WProperty)((Object)rProperty);
                List list = ManyToManyHandler.this.getManyEntities((Property)rProperty);
                wProperty2.set(list);
                IndexedProperty indexedProperty = (IndexedProperty)rProperty;
                BeanEventManager beanEventManager = ((HasEventManager)((Object)rProperty)).getEventManager();
                onGetListener.setOnGet(null);
                ManyToManyHandler.this.mergeImpl((InternalSession)CurrentSession.get(), indexedProperty, list);
            }
        });
    }

    @Override
    public List<T> getManyEntities(Property property) {
        InternalSession internalSession = (InternalSession)CurrentSession.get();
        List list = internalSession.getSecondLevelCache().getIndexedProperty((IndexedProperty)property, internalSession);
        if (list != null) {
            return list;
        }
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.append("select ");
        queryStringBuilder.appendColumns(this.getForeignEntityPersister().getSelectColumns(), "a.", "", ", ");
        queryStringBuilder.append(" from ");
        queryStringBuilder.append(this.getForeignEntityPersister().getTableName() + " as a");
        queryStringBuilder.append(", " + this.getTableName() + " as b");
        queryStringBuilder.append(" where ");
        String string = "";
        for (String string2 : this.getLocalKeyColumnNames()) {
            queryStringBuilder.append(string);
            queryStringBuilder.append("b.");
            queryStringBuilder.append(string2);
            queryStringBuilder.append(" = ?");
            string = " and ";
        }
        String[] stringArray = this.getForeignKeyColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            queryStringBuilder.append(" and ");
            queryStringBuilder.append("b." + stringArray[i]);
            queryStringBuilder.append(" = ");
            queryStringBuilder.append("a.");
            queryStringBuilder.append(this.getForeignEntityPersister().getPrimaryKeyColumns().get(i).getName());
        }
        List list2 = new SelectManyQuery(internalSession.getConnection(), queryStringBuilder.toString(), property.getParent()).getResults();
        internalSession.getSecondLevelCache().cacheIndexedProperty((IndexedProperty)property, list2);
        return list2;
    }

    public EntityPersister<T> getForeignEntityPersister() {
        if (this._foreignEntityPersister == null) {
            this._foreignEntityPersister = this.getSessionConfiguration().getPersister(this.getForeignEntityType());
        }
        return this._foreignEntityPersister;
    }

    @Override
    public String getTableName() {
        if (this._tableName == null) {
            String string;
            String string2 = this.getParentEntityPersister().getTableName();
            if (string2.compareTo(string = this.getForeignEntityPersister().getTableName()) > 0) {
                String string3 = string;
                string = string2;
                string2 = string3;
            }
            this._tableName = string2 + "_" + string;
        }
        return this._tableName;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public void setLocalKeyColumnNames(String[] stringArray) {
        this._localKeyColumnNames = stringArray;
    }

    public void setForeignKeyColumnNames(String[] stringArray) {
        this._foreignKeyColumnNames = stringArray;
    }

    public Class<Set<T>> getForeignEntityType() {
        return this.getPropertyContext().getType();
    }

    public String[] getLocalKeyColumnNames() {
        if (this._localKeyColumnNames == null) {
            this._localKeyColumnNames = this.collectColumnNames(this.getParentEntityPersister());
        }
        return this._localKeyColumnNames;
    }

    String[] collectColumnNames(EntityPersister entityPersister) {
        List<ColumnContext> list = entityPersister.getPrimaryKeyColumns();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = entityPersister.getTableName() + "_" + list.get(i).getName();
        }
        return stringArray;
    }

    public String[] getForeignKeyColumnNames() {
        if (this._foreignKeyColumnNames == null) {
            this._foreignKeyColumnNames = this.collectColumnNames(this.getForeignEntityPersister());
        }
        return this._foreignKeyColumnNames;
    }

    @Override
    public void activated() {
        this.setColumns(new ArrayList<ColumnContext>());
        super.activated();
        ManyToMany manyToMany = this.getPropertyContext().getReflector().getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            if (manyToMany.foreignKeyColumns().length() > 0) {
                this.setForeignKeyColumnNames(manyToMany.foreignKeyColumns().split(","));
            }
            if (manyToMany.localKeyColumns().length() > 0) {
                this.setLocalKeyColumnNames(manyToMany.localKeyColumns().split(","));
            }
            if (manyToMany.tableName().length() > 0) {
                this.setTableName(manyToMany.tableName());
            }
            this.setTransientSide(manyToMany.transientSide());
        }
    }

    public List<ColumnContext> cloneColumns(List<ColumnContext> list) {
        ArrayList<ColumnContext> arrayList = new ArrayList<ColumnContext>();
        for (ColumnContext columnContext : list) {
            arrayList.add(columnContext.clone());
        }
        return arrayList;
    }

    @Override
    public void createTable() {
        String string = this.getCreateTableSql();
        new UpdateQuery(string).execute();
    }

    @Override
    public String getCreateTableSql() {
        ArrayList<ColumnContext> arrayList = new ArrayList<ColumnContext>();
        this.addColumns(arrayList, this.getParentEntityPersister().getPrimaryKeyColumns(), this.getLocalKeyColumnNames());
        this.addColumns(arrayList, this.getForeignEntityPersister().getPrimaryKeyColumns(), this.getForeignKeyColumnNames());
        SQLDialect sQLDialect = this.getParentEntityPersister().getSessionConfiguration().getSqlDialect();
        String string = sQLDialect.getCreateTableSQL(this.getTableName(), arrayList);
        return string;
    }

    private void addColumns(List<ColumnContext> list, List<ColumnContext> list2, String[] stringArray) {
        int n = 0;
        for (ColumnContext columnContext : this.cloneColumns(list2)) {
            if (stringArray != null && stringArray.length > n) {
                columnContext.setName(stringArray[n]);
            }
            list.add(columnContext);
            ++n;
        }
    }

    public boolean needsMerging() {
        return false;
    }

    int getColumnCount() {
        return this._foreignKeyColumnNames.length + this._localKeyColumnNames.length;
    }

    private List<String> getForeignAndLocalColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, this.getForeignKeyColumnNames());
        Collections.addAll(arrayList, this.getLocalKeyColumnNames());
        return arrayList;
    }

    private String getInsertQuery() {
        if (this._insertQuery == null) {
            QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
            queryStringBuilder.append("insert into ");
            queryStringBuilder.append(this.getTableName());
            queryStringBuilder.append(" (");
            queryStringBuilder.appendStrings(this.getForeignAndLocalColumns(), ", ");
            queryStringBuilder.append(" ) values ( ");
            queryStringBuilder.appendRepeated("?", ", ", this.getForeignAndLocalColumns().size());
            queryStringBuilder.append(" )");
            this._insertQuery = queryStringBuilder.toString();
        }
        return this._insertQuery;
    }

    private String getDeleteQuery() {
        if (this._deleteQuery == null) {
            QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
            queryStringBuilder.append("delete from ");
            queryStringBuilder.append(this.getTableName());
            queryStringBuilder.append(" where ");
            queryStringBuilder.appendStrings(this.getForeignAndLocalColumns(), " = ? ", " and ");
            this._deleteQuery = queryStringBuilder.getSql();
        }
        return this._deleteQuery;
    }

    @Override
    public void merge(Session session, BaseProperty baseProperty, PropertyListener propertyListener) {
        this.mergeImpl((InternalSession)session, (IndexedProperty)baseProperty, null);
    }

    private void mergeImpl(final InternalSession internalSession, final IndexedProperty<T> indexedProperty, List<T> list) {
        if (!this._transientSide) {
            if (list == null) {
                if (((OnGetListener)((Object)indexedProperty)).getOnGet() instanceof LazyLoader) {
                    return;
                }
                list = (List)indexedProperty.get();
            }
            final ArrayList<T> arrayList = new ArrayList<T>(list);
            BeanEventManager beanEventManager = ((HasEventManager)((Object)indexedProperty)).getEventManager();
            beanEventManager.addListener(new IndexedPropertyListener(){
                CollectionProxy _collectionProxy;

                public CollectionProxy getCollectionProxy() {
                    if (this._collectionProxy == null) {
                        this._collectionProxy = new CollectionProxy(internalSession, indexedProperty, arrayList);
                    }
                    return this._collectionProxy;
                }

                @Override
                public void propertyInserted(IndexedProperty indexedProperty2, Object object, int n) {
                    internalSession.merge(this.getCollectionProxy());
                }

                @Override
                public void propertyRemoved(IndexedProperty indexedProperty2, Object object, int n) {
                    internalSession.merge(this.getCollectionProxy());
                }

                @Override
                public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
                    internalSession.merge(this.getCollectionProxy());
                }
            });
        } else {
            BeanEventManager beanEventManager = ((HasEventManager)((Object)indexedProperty)).getEventManager();
            beanEventManager.addListener(new IndexedPropertyListener(){

                @Override
                public void propertyInserted(IndexedProperty indexedProperty, Object object, int n) {
                    internalSession.evictCollectionFromSecondLevelCacheOnCommit(indexedProperty);
                }

                @Override
                public void propertyRemoved(IndexedProperty indexedProperty, Object object, int n) {
                    internalSession.evictCollectionFromSecondLevelCacheOnCommit(indexedProperty);
                }

                @Override
                public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
                    internalSession.evictCollectionFromSecondLevelCacheOnCommit((IndexedProperty)baseProperty);
                }
            });
        }
    }

    public void setTransientSide(boolean bl) {
        this._transientSide = bl;
    }

    @Override
    public void processCascade(InternalSession internalSession, Object object) {
        boolean bl = internalSession.isPersisted(object);
        this.toString();
    }

    public class CollectionProxy
    implements SessionAware {
        private final Logger logger = BeanPropsLoggerHelper.getLogger();
        private final IndexedProperty<T> _indexedProperty;
        private List<T> _originalCollection;
        private final InternalSession _session;

        private CollectionProxy(InternalSession internalSession, IndexedProperty<T> indexedProperty, List<T> list) {
            this._session = internalSession;
            this._indexedProperty = indexedProperty;
            this._originalCollection = list;
        }

        public void setOriginalCollection(List<T> list) {
            if (this._originalCollection != null && this._originalCollection.size() == 0 && list.size() == 0) {
                return;
            }
            this._originalCollection = new ArrayList(list);
        }

        @Override
        public void processDeletes() {
            List list = (List)this._indexedProperty.get();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object t : this._originalCollection) {
                if (list.contains(t)) continue;
                arrayList.add(t);
            }
            if (arrayList.size() > 0) {
                this._session.evictCollectionFromSecondLevelCacheOnCommit(this._indexedProperty);
            }
            this.processBeanQueries(ManyToManyHandler.this.getDeleteQuery(), arrayList);
        }

        @Override
        public void processInserts() {
            List list = (List)this._indexedProperty.get();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object e : list) {
                if (this._originalCollection.contains(e)) continue;
                arrayList.add(e);
            }
            if (arrayList.size() > 0) {
                this._session.evictCollectionFromSecondLevelCacheOnCommit(this._indexedProperty);
            }
            this.processBeanQueries(ManyToManyHandler.this.getInsertQuery(), arrayList);
        }

        @Override
        public void flushCompleted() {
            this.setOriginalCollection((List)this._indexedProperty.get());
        }

        void processBeanQueries(String string, List<Object> list) {
            if (list.size() == 0) {
                return;
            }
            new BatchUpdateQuery<Object>(string, list, this._session.getConnection()){

                @Override
                protected void addBeanToBatchStatement(Object object) throws SQLException {
                    Object[] objectArray = new Object[ManyToManyHandler.this.getColumnCount()];
                    EntityPersister.processPreparedStatementHandlers(object, this.getStatement(), ManyToManyHandler.this.getForeignEntityPersister().getPrimaryKeyColumns());
                    EntityPersister.processPreparedStatementHandlers(CollectionProxy.this._indexedProperty.getParent(), this.getStatement(), ManyToManyHandler.this.getParentEntityPersister().getPrimaryKeyColumns(), ManyToManyHandler.this.getForeignEntityPersister().getPrimaryKeyColumns().size());
                }
            }.execute();
        }

        @Override
        public void processUpdates() {
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this._indexedProperty == null ? 0 : this._indexedProperty.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CollectionProxy collectionProxy = (CollectionProxy)object;
            return !(this._indexedProperty == null ? collectionProxy._indexedProperty != null : !this._indexedProperty.equals(collectionProxy._indexedProperty));
        }
    }

    class SelectManyQuery
    extends SelectQuery<T> {
        private final Object _bean;

        SelectManyQuery(Connection connection, String string, Object object) {
            super(string, connection);
            this._bean = object;
            this.execute();
        }

        @Override
        protected void prepareQuery() throws SQLException {
            Object[] objectArray = ManyToManyHandler.this.getParentEntityPersister().getPrimaryKeyColumnValues(this._bean);
            EntityPersister.processPreparedStatementHandlers(this._bean, this.getStatement(), ManyToManyHandler.this.getParentEntityPersister().getPrimaryKeyColumns());
        }

        @Override
        protected T processRow(ResultSet resultSet) throws SQLException {
            return ManyToManyHandler.this.getForeignEntityPersister().createFromResultSet(resultSet);
        }
    }
}

