/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.IndexedPropertyListener;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.AbstractLazyLoaderPropertyListener;
import net.java.dev.properties.jdbc.CascadeHandler;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.PersistenceStrategy;
import net.java.dev.properties.jdbc.SelectQuery;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.handlers.AbstractTypeHandler;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.ManyHandlerInterface;
import net.java.dev.properties.jdbc.handlers.SingleEntityHandler;

public class ManyEntityHandler<T>
extends AbstractTypeHandler<T>
implements ManyHandlerInterface<T>,
CascadeHandler {
    private SingleEntityHandler<Object> _foreignTypeHandler;
    private EntityPersister<?> _foreignEntityPersister;
    private PersistenceStrategy _persistenceStrategy;
    static final String FOREIGN_BIDI_ATTR = "ForeignBidiPropertyContext";

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public void activated() {
        this.setColumns(new ArrayList<ColumnContext>());
        this._persistenceStrategy = this.getSessionConfiguration().getPersistenceStrategy();
    }

    @Override
    public void mapColumnToPreparedStatement(Object object, int n, PreparedStatement preparedStatement, int n2) throws SQLException {
    }

    @Override
    public void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        if (!(wProperty instanceof OnGetListener)) {
            throw new RuntimeException("properties must implement");
        }
        new AbstractLazyLoaderPropertyListener(wProperty){
            private static final long serialVersionUID = 2901153857814516847L;

            @Override
            public void onGetImpl(final RProperty<?> rProperty) {
                BeanContainer.get().doWithEventSuppression(new Runnable(){

                    @Override
                    public void run() {
                        InternalSession internalSession = (InternalSession)CurrentSession.get();
                        WProperty wProperty = (WProperty)((Object)rProperty);
                        List list = ManyEntityHandler.this.getManyEntities((Property)rProperty);
                        internalSession.pushDirtyCheckingSuspension();
                        wProperty.set(list);
                        internalSession.popDirtyCheckingSuspension();
                    }
                });
            }

            @Override
            public Object[] getPrimaryKeyValues() {
                return ManyEntityHandler.this.getParentEntityPersister().getPrimaryKeyColumnValues(this.getProperty().getParent());
            }
        };
    }

    @Override
    public List getManyEntities(Property property) {
        final InternalSession internalSession = (InternalSession)CurrentSession.get();
        List list = internalSession.getSecondLevelCache().getIndexedProperty((IndexedProperty)property, internalSession);
        if (list == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (ColumnContext columnContext : this.getForeignTypeHandler().getColumns()) {
                stringBuilder.append(string);
                stringBuilder.append(columnContext.getName());
                stringBuilder.append(" = ?");
                string = " and ";
            }
            String string2 = this.getForeignEntityPersister().getSelectQuery() + " where " + stringBuilder;
            list = new SelectManyQuery(string2, property.getParent(), CurrentSession.get().getConnection()).getResults();
            internalSession.getSecondLevelCache().cacheIndexedProperty((IndexedProperty)property, list);
        }
        ((HasEventManager)((Object)property)).getEventManager().addListener(new IndexedPropertyListener(){
            private static final long serialVersionUID = 5958449022235690295L;

            @Override
            public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
                internalSession.evictCollectionFromSecondLevelCacheOnCommit((IndexedProperty)baseProperty);
            }

            @Override
            public void propertyInserted(IndexedProperty indexedProperty, Object object, int n) {
                internalSession.evictCollectionFromSecondLevelCacheOnCommit(indexedProperty);
            }

            @Override
            public void propertyRemoved(IndexedProperty indexedProperty, Object object, int n) {
                internalSession.evictCollectionFromSecondLevelCacheOnCommit(indexedProperty);
            }
        });
        return list;
    }

    public SingleEntityHandler<Object> getForeignTypeHandler() {
        if (this._foreignTypeHandler == null) {
            IPropertyContext iPropertyContext = ManyEntityHandler.getForeignBidiPropertyContext(this.getPropertyContext());
            this._foreignTypeHandler = (SingleEntityHandler)this.getForeignEntityPersister().getTypeHandler(iPropertyContext);
        }
        return this._foreignTypeHandler;
    }

    EntityPersister getForeignEntityPersister() {
        if (this._foreignEntityPersister == null) {
            this._foreignEntityPersister = this.getSessionConfiguration().getPersister(this.getManyEntityType());
        }
        return this._foreignEntityPersister;
    }

    public Class<Set<T>> getManyEntityType() {
        return this.getPropertyContext().getType();
    }

    public boolean needsMerging() {
        return false;
    }

    @Override
    public void merge(Session session, BaseProperty baseProperty, PropertyListener propertyListener) {
    }

    @Override
    public void processCascade(InternalSession internalSession, Object object) {
        List list = (List)this.getPropertyContext().getValue(object);
        for (Object e : list) {
            if (e == null || this._persistenceStrategy.isPersisted(internalSession, e)) continue;
            internalSession.insert(e);
        }
    }

    static IPropertyContext getForeignBidiPropertyContext(IPropertyContext iPropertyContext) {
        IPropertyContext iPropertyContext2 = (IPropertyContext)iPropertyContext.getAttribute(FOREIGN_BIDI_ATTR);
        if (iPropertyContext2 != null) {
            return iPropertyContext2;
        }
        Bidirectional bidirectional = iPropertyContext.getAnnotation(Bidirectional.class);
        if (bidirectional == null) {
            return null;
        }
        IBeanContext iBeanContext = BeanContainer.get().getContext(iPropertyContext.getType());
        for (IPropertyContext iPropertyContext3 : iBeanContext.getBidiProperties()) {
            Bidirectional bidirectional2 = iPropertyContext3.getAnnotation(Bidirectional.class);
            if (bidirectional2 == null || !bidirectional2.value().equals(bidirectional.value())) continue;
            iPropertyContext2 = iPropertyContext3;
            break;
        }
        if (iPropertyContext2 == null) {
            throw new RuntimeException("unable to find bidi property for " + iPropertyContext);
        }
        return iPropertyContext2;
    }

    private class SimpleProperty
    implements RProperty<Object> {
        private static final long serialVersionUID = 7535639647460529803L;
        private Object _value;

        private SimpleProperty() {
        }

        @Override
        public Object get() {
            return this._value;
        }

        @Override
        public IPropertyContext getContext() {
            return null;
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        public void setContext(IPropertyContext iPropertyContext) {
        }

        @Override
        public void setParent(Object object) {
        }
    }

    class SelectManyQuery
    extends SelectQuery<T> {
        private Object _bean;

        SelectManyQuery(String string, Object object, Connection connection) {
            super(string, connection, false);
            this._bean = object;
            this.execute();
        }

        @Override
        protected void prepareQuery() throws SQLException {
            EntityPersister.processPreparedStatementHandlers(this._bean, this.getStatement(), ManyEntityHandler.this.getParentEntityPersister().getPrimaryKeyColumns());
        }

        @Override
        protected T processRow(ResultSet resultSet) throws SQLException {
            return ManyEntityHandler.this.getForeignEntityPersister().createFromResultSet(resultSet);
        }
    }
}

