/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.util.List;
import net.java.dev.properties.jdbc.handlers.ObjectToStringHandler;
import net.model3.bean.converters.Converter;
import net.model3.collections.ListX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ListToStringHandler<T>
extends ObjectToStringHandler<List<T>> {
    private static final Logger logger = LoggerHelper.getLogger();
    Converter<T> _elementConverter;
    String _seperator = ",";

    @Override
    public String convertObjectToString(List<T> list) {
        if (list == null) {
            return "";
        }
        return StringX.join(list, (String)this._seperator, this.getElementConverter());
    }

    public Converter<T> getElementConverter() {
        if (this._elementConverter == null) {
            this._elementConverter = this._converterFactory.getConverter(this.getPropertyContext().getType());
        }
        return this._elementConverter;
    }

    public void setElementConverter(Converter<T> converter) {
        this._elementConverter = converter;
    }

    @Override
    public List<T> convertStringToObject(String string) {
        List list = ListX.create();
        if (string != null) {
            for (String string2 : string.split(this._seperator)) {
                if (StringX.isBlank((String)(string2 = string2.trim()))) continue;
                try {
                    list.add(this.getElementConverter().stringToValue(this.getPropertyContext().getType(), string2));
                }
                catch (Exception exception) {
                    logger.warn((Object)"unable to parse {} into a {}", (Object)string2, this.getPropertyContext().getType());
                }
            }
        }
        return list;
    }

    @Override
    protected boolean autoHandleNulls() {
        return false;
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    public String getSeperator() {
        return this._seperator;
    }
}

