/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.JdbcException;
import net.java.dev.properties.jdbc.QueryForLong;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.java.dev.properties.jdbc.handlers.TableCreator;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public class IdGeneratorHandler<T>
extends SingleColumnHandler<T>
implements TableCreator {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private final String _autoIncrementTableName = "auto_increment_table";
    private String _tableColumn = "table_name";
    private String _idColumn = "last_id_used";
    private String _parentBeanTableName;
    private long _initialValue;
    private final ThreadLocal<Connection> _connectionThreadLocal = new ThreadLocal();

    @Override
    public Integer getSqlTypeAsInteger() {
        return -5;
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public Object getColumnValue(Object object, int n) {
        Object object2 = super.getColumnValue(object, n);
        if (object2 == null) {
            Long l = this.getNextIdValue();
            this.getPropertyContext().setValue(object, l);
            object2 = l;
        }
        return object2;
    }

    @Override
    public void mapColumnValueToPreparedStatement(T t, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setLong(n, (Long)t);
    }

    public void dropTable() {
        String string = "DROP TABLE auto_increment_table IF EXISTS";
        new UpdateQuery(string).execute();
    }

    @Override
    public void createTable() {
        String string = this.getCreateTableSql();
        new UpdateQuery(string).execute();
    }

    @Override
    public String getCreateTableSql() {
        return "CREATE TABLE auto_increment_table ( " + this._tableColumn + " VARCHAR(255), " + this._idColumn + " BIGINT, PRIMARY KEY( " + this._tableColumn + " ) )";
    }

    @Override
    public String getTableName() {
        return "auto_increment_table";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextIdValue() {
        try {
            long l;
            Connection connection = this.getSessionConfiguration().getConnectionProvider().open();
            this._connectionThreadLocal.set(connection);
            boolean bl = false;
            bl = connection.getAutoCommit();
            connection.setAutoCommit(true);
            try {
                long l2;
                while (!this.updateIdValue(l2 = this.getCurrentIdValue(), l = l2 + 1L)) {
                }
            }
            finally {
                connection.setAutoCommit(bl);
                this._connectionThreadLocal.set(null);
                this.getSessionConfiguration().getConnectionProvider().close(connection);
            }
            return l;
        }
        catch (SQLException sQLException) {
            throw new JdbcException(sQLException);
        }
    }

    private long getCurrentIdValueImpl() {
        String string = "select " + this._idColumn + " from " + "auto_increment_table" + " where " + this._tableColumn + " = ?";
        Connection connection = this._connectionThreadLocal.get();
        QueryForLong queryForLong = new QueryForLong(string, connection, new Object[0]);
        queryForLong.setArguments(this.getParentBeanTableName());
        Long l = (Long)queryForLong.getResult();
        if (l == null) {
            this.insertInitialValue(0L, connection);
            return 0L;
        }
        return l;
    }

    public long getCurrentIdValue() {
        return this.getCurrentIdValueImpl();
    }

    public void insertInitialValue(final long l, Connection connection) {
        try {
            String string = "insert into auto_increment_table ( " + this._tableColumn + ", " + this._idColumn + " ) VALUES( ?, ? )";
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new Object());
            new UpdateQuery(string, connection){

                @Override
                protected void prepareQuery() throws SQLException {
                    this.getStatement().setString(1, IdGeneratorHandler.this.getParentBeanTableName());
                    this.getStatement().setLong(2, l);
                }
            }.execute();
            connection.commit();
        }
        catch (Exception exception) {
            logger.error("", (Throwable)exception);
            throw new JdbcException(exception);
        }
    }

    public boolean updateIdValue(final long l, final long l2) throws SQLException {
        String string = "update auto_increment_table set " + this._idColumn + " = ? where " + this._tableColumn + " = ? and " + this._idColumn + " = ?";
        UpdateQuery updateQuery = new UpdateQuery(string, this._connectionThreadLocal.get()){

            @Override
            protected void prepareQuery() throws SQLException {
                this.getStatement().setLong(1, l2);
                this.getStatement().setString(2, IdGeneratorHandler.this.getParentBeanTableName());
                this.getStatement().setLong(3, l);
            }
        };
        updateQuery.execute();
        this._connectionThreadLocal.get().commit();
        return updateQuery.getNumberOfRowsUpdated() != 0;
    }

    @Override
    public void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        wProperty.set(resultSet.getLong(n));
    }

    public String getIdColumn() {
        return this._idColumn;
    }

    public void setIdColumn(String string) {
        this._idColumn = string;
    }

    public long getInitialValue() {
        return this._initialValue;
    }

    public void setInitialValue(long l) {
        this._initialValue = l;
    }

    public String getTableColumn() {
        return this._tableColumn;
    }

    public void setTableColumn(String string) {
        this._tableColumn = string;
    }

    public String getParentBeanTableName() {
        if (this._parentBeanTableName == null) {
            return this.getParentBeanContext().getTableName();
        }
        return this._parentBeanTableName;
    }

    public void setParentBeanTableName(String string) {
        this._parentBeanTableName = string;
    }
}

