/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.lang.ClassX;
import net.model3.lang.EnumX;

public class EnumStringHandler
extends SingleColumnHandler<Enum> {
    @Override
    public void activated() {
        if (this.getOrmContext().getLength() == null) {
            List list = EnumX.valuesAsList(this.getPropertyContext().getType());
            int n = 0;
            for (Enum enum_ : list) {
                n = Math.max(n, enum_.name().length());
            }
            this.getOrmContext().setLength(n);
        }
        if (this.getOrmContext().getSqlType() == null) {
            this.getOrmContext().setSqlType(this.getSessionConfiguration().getSqlDialect().getDefaultStringType().getSqlType());
        }
        super.activated();
    }

    @Override
    public void mapColumnValueToPreparedStatement(Enum enum_, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, enum_.name());
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return ClassX.isAssignable(Enum.class, clazz);
    }

    @Override
    public void loadProperty(WProperty<Enum> wProperty, ResultSet resultSet, int n) throws SQLException {
        Class<?> clazz = this.getPropertyContext().getType();
        String string = resultSet.getString(n);
        if (string != null) {
            wProperty.set((Enum)Enum.valueOf(clazz, string.trim()));
        } else {
            wProperty.set(null);
        }
    }
}

