/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;

public class EnumIntHandler<T extends Enum>
extends SingleColumnHandler<T> {
    private Method _valuesMethod;

    @Override
    public Integer getSqlTypeAsInteger() {
        return 4;
    }

    @Override
    public void mapColumnValueToPreparedStatement(T t, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(n, ((Enum)t).ordinal());
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public void loadProperty(WProperty<T> wProperty, ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        wProperty.set(this.valueOf(n2));
    }

    public T valueOf(int n) {
        try {
            Enum[] enumArray;
            if (this._valuesMethod == null) {
                enumArray = this.getPropertyContext().getType();
                this._valuesMethod = enumArray.getMethod("values", new Class[0]);
            }
            enumArray = (Enum[])this._valuesMethod.invoke(null, new Object[0]);
            if (n >= 0 && n < enumArray.length) {
                return (T)enumArray[n];
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

