/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.EnumHandlerInterface;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.collections.MapX;
import net.model3.lang.EnumX;

public class EnumDelegatingInterfaceHandler
extends SingleColumnHandler<EnumHandlerInterface> {
    private Map<String, EnumHandlerInterface> _databaseValueToEnumMap = MapX.create();

    @Override
    public Integer getSqlTypeAsInteger() {
        return 12;
    }

    @Override
    public void mapColumnValueToPreparedStatement(EnumHandlerInterface enumHandlerInterface, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, enumHandlerInterface.getDatabaseValue());
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public void loadProperty(WProperty<EnumHandlerInterface> wProperty, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        EnumHandlerInterface enumHandlerInterface = this._databaseValueToEnumMap.get(string);
        wProperty.set(enumHandlerInterface);
    }

    @Override
    public void activated() {
        Enum[] enumArray;
        super.activated();
        for (Enum enum_ : enumArray = EnumX.values(this.getPropertyContext().getType())) {
            EnumHandlerInterface enumHandlerInterface = (EnumHandlerInterface)((Object)enum_);
            this._databaseValueToEnumMap.put(enumHandlerInterface.getDatabaseValue(), enumHandlerInterface);
        }
    }
}

