/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.chrono.DateTime;

public class DateTimeHandler
extends SingleColumnHandler<DateTime> {
    @Override
    public void mapColumnValueToPreparedStatement(DateTime dateTime, PreparedStatement preparedStatement, int n) throws SQLException {
        Timestamp timestamp = null;
        if (dateTime != null) {
            timestamp = dateTime.asSqlTimestamp();
        }
        if (timestamp == null) {
            preparedStatement.setNull(n, 93);
        } else {
            preparedStatement.setTimestamp(n, timestamp);
        }
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(DateTime.class);
    }

    @Override
    public void loadProperty(WProperty<DateTime> wProperty, ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        DateTime dateTime = null;
        if (timestamp != null) {
            dateTime = new DateTime((Date)timestamp);
        }
        wProperty.set(dateTime);
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return 93;
    }
}

