/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.model3.chrono.DateOnly;

public class DateOnlyHandler
extends SingleColumnHandler<DateOnly> {
    @Override
    public void mapColumnValueToPreparedStatement(DateOnly dateOnly, PreparedStatement preparedStatement, int n) throws SQLException {
        java.sql.Date date = null;
        if (dateOnly != null) {
            date = dateOnly.asSqlDate();
        }
        preparedStatement.setDate(n, date);
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(DateOnly.class);
    }

    @Override
    public void loadProperty(WProperty<DateOnly> wProperty, ResultSet resultSet, int n) throws SQLException {
        java.sql.Date date = resultSet.getDate(n);
        DateOnly dateOnly = null;
        if (date != null) {
            dateOnly = new DateOnly((Date)date);
        }
        wProperty.set(dateOnly);
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return 91;
    }
}

