/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import net.java.dev.properties.jdbc.dialect.SqlType;
import net.java.dev.properties.jdbc.handlers.TypeHandler;

public class ColumnContext
implements Cloneable {
    private String _name;
    private SqlType _sqlType;
    private boolean _nullable = true;
    private boolean _readOnly;
    private TypeHandler _typeHandler;
    private int _columnIndexInTypeHandler;
    private boolean _primaryKey;
    private Integer _decimals;
    private Long _length;
    private String _sqlTypeAsString;

    public Object getColumnValue(Object object) {
        return this._typeHandler.getColumnValue(object, this._columnIndexInTypeHandler);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (string.endsWith("!")) {
            this._readOnly = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("!")) {
            this._readOnly = true;
            string = string.substring(1);
        }
        this._name = string;
    }

    public SqlType getSqlType() {
        return this._sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        if (sqlType == null) {
            sqlType = null;
        }
        this._sqlType = sqlType;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
    }

    public TypeHandler getTypeHandler() {
        return this._typeHandler;
    }

    public int getColumnIndexInTypeHandler() {
        return this._columnIndexInTypeHandler;
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public void setColumnIndexInTypeHandler(int n) {
        this._columnIndexInTypeHandler = n;
    }

    public void setNullable(boolean bl) {
        this._nullable = bl;
    }

    public void setPrimaryKey(boolean bl) {
        this._primaryKey = bl;
    }

    public void setTypeHandler(TypeHandler typeHandler) {
        this._typeHandler = typeHandler;
    }

    public String toString() {
        return this.getName() + " " + this.getSqlType().getSqlTypeName();
    }

    public Integer getDecimals() {
        return this._decimals;
    }

    public void setDecimals(Integer n) {
        this._decimals = n;
    }

    public Long getLength() {
        return this._length;
    }

    public void setLength(Long l) {
        this._length = l;
    }

    public ColumnContext clone() {
        try {
            return (ColumnContext)super.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getSqlTypeAsString() {
        if (this._sqlTypeAsString == null) {
            this._sqlTypeAsString = this.getSqlType().getSqlTypeStringForCreateTable(this);
        }
        return this._sqlTypeAsString;
    }

    public void setSqlTypeAsString(String string) {
        this._sqlTypeAsString = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._name == null ? 0 : this._name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnContext columnContext = (ColumnContext)object;
        return !(this._name == null ? columnContext._name != null : !this._name.equals(columnContext._name));
    }
}

