/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;
import net.java.dev.properties.util.ByteArrayWrapper;

public class ByteArrayToBase64StringHandler
extends SingleColumnHandler<ByteArrayWrapper> {
    private Base64Encoder _encoder = new Base64Encoder();

    @Override
    public void mapColumnValueToPreparedStatement(ByteArrayWrapper byteArrayWrapper, PreparedStatement preparedStatement, int n) throws SQLException {
        String string = this._encoder.encode(byteArrayWrapper.getBuffer());
        preparedStatement.setString(n, string);
    }

    @Override
    public Integer getSqlTypeAsInteger() {
        return this.getSessionConfiguration().getSqlDialect().getDefaultStringType().getSqlType();
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return false;
    }

    @Override
    public void loadProperty(WProperty<ByteArrayWrapper> wProperty, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        byte[] byArray = null;
        if (string != null) {
            byArray = this._encoder.decode(string);
        }
        wProperty.set(new ByteArrayWrapper(byArray));
    }
}

