/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.handlers.SingleColumnHandler;

public class BigDecimalHandler
extends SingleColumnHandler<BigDecimal> {
    @Override
    public Integer getSqlTypeAsInteger() {
        return 3;
    }

    @Override
    public boolean canHandleType(Class<?> clazz) {
        return clazz.equals(BigDecimal.class);
    }

    public BigDecimal get(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getBigDecimal(n);
    }

    @Override
    public void loadProperty(WProperty<BigDecimal> wProperty, ResultSet resultSet, int n) throws SQLException {
        wProperty.set(resultSet.getBigDecimal(n));
    }

    @Override
    public void mapColumnValueToPreparedStatement(BigDecimal bigDecimal, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBigDecimal(n, bigDecimal);
    }
}

