/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.handlers;

import java.util.ArrayList;
import java.util.List;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.OrmPropertyContext;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.dialect.SqlType;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.LifecycleAwareTypeHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandlerFactory;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public abstract class AbstractTypeHandler<T>
implements LifecycleAwareTypeHandler<T> {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private IPropertyContext _propertyContext;
    private EntityPersister<Object> _parentEntityPersister;
    private List<ColumnContext> _columns;
    private TypeHandlerFactory _handlerFactory;

    @Override
    public IPropertyContext getPropertyContext() {
        return this._propertyContext;
    }

    @Override
    public void setPropertyContext(IPropertyContext iPropertyContext) {
        this._propertyContext = iPropertyContext;
    }

    public IBeanContext getParentBeanContext() {
        return this.getPropertyContext().getParentBeanContext();
    }

    @Override
    public OrmPropertyContext getOrmContext() {
        return this.getPropertyContext().getOrmContext();
    }

    public void setColumn(ColumnContext columnContext) {
        this._columns = new ArrayList<ColumnContext>();
        this._columns.add(columnContext);
        if (this.getOrmContext().getLength() != null) {
            columnContext.setLength(this.getOrmContext().getLength());
        }
        if (this.getOrmContext().getDecimals() != null) {
            columnContext.setDecimals(this.getOrmContext().getDecimals());
        }
    }

    @Override
    public List<ColumnContext> getColumns() {
        return this._columns;
    }

    protected void setColumns(List<ColumnContext> list) {
        this._columns = list;
    }

    public TypeHandlerFactory getHandlerFactory() {
        return this._handlerFactory;
    }

    @Override
    public void setHandlerFactory(TypeHandlerFactory typeHandlerFactory) {
        this._handlerFactory = typeHandlerFactory;
    }

    @Override
    public void activated() {
    }

    @Override
    public Object getColumnValue(Object object, int n) {
        if (object == null) {
            return null;
        }
        return this.getPropertyContext().getValue(object);
    }

    public EntityPersister<Object> getParentEntityPersister() {
        return this._parentEntityPersister;
    }

    @Override
    public void setParentEntityPersister(EntityPersister<?> entityPersister) {
        this._parentEntityPersister = entityPersister;
    }

    protected ColumnContext createColumnContext(SqlType sqlType) {
        return this.createColumnContext(this.getOrmContext().getColumnName(), sqlType, this.getPropertyContext().isNullable(), this.getOrmContext().isPrimaryKey(), 0, null, null);
    }

    public ColumnContext createColumnContext(String string, ColumnContext columnContext, boolean bl, int n) {
        return this.createColumnContext(string, columnContext.getSqlType(), columnContext.isNullable(), bl, n, columnContext.getLength(), columnContext.getDecimals());
    }

    protected ColumnContext createColumnContext(String string, SqlType sqlType, boolean bl, boolean bl2, int n, Long l, Integer n2) {
        ColumnContext columnContext = new ColumnContext();
        columnContext.setPrimaryKey(bl2);
        columnContext.setColumnIndexInTypeHandler(n);
        columnContext.setName(string);
        columnContext.setNullable(bl);
        columnContext.setSqlType(sqlType);
        columnContext.setTypeHandler(this);
        columnContext.setLength(l);
        columnContext.setDecimals(n2);
        return columnContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getParentBeanContext() != null) {
            stringBuilder.append(this.getParentBeanContext().getName());
        } else {
            stringBuilder.append("nullBeanContext");
        }
        stringBuilder.append(".");
        if (this.getPropertyContext() != null) {
            stringBuilder.append(this.getPropertyContext().getName());
        } else {
            stringBuilder.append("nullPropertyContext");
        }
        return stringBuilder.toString();
    }

    @Override
    public void merge(Session session, BaseProperty baseProperty, PropertyListener propertyListener) {
        ((HasEventManager)((Object)baseProperty)).getEventManager().addListener(propertyListener);
    }

    public SessionConfiguration getSessionConfiguration() {
        return this._handlerFactory.getSessionConfiguration();
    }
}

