/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.dialect;

import net.java.dev.properties.jdbc.dialect.SQLDialect;
import net.java.dev.properties.jdbc.handlers.ColumnContext;

public abstract class SqlType {
    private int _sqlType;
    private String _sqlTypeName;
    private SQLDialect.LengthParmConstraint _lengthParmConstraint;
    private Class<?> _javaType;

    public SqlType(int n, String string, SQLDialect.LengthParmConstraint lengthParmConstraint, Class<?> clazz) {
        this._sqlType = n;
        this._sqlTypeName = string.toLowerCase();
        this._lengthParmConstraint = lengthParmConstraint;
        this._javaType = clazz;
    }

    public SqlType(int n, String string, Class<?> clazz) {
        this._sqlType = n;
        this._sqlTypeName = string.toLowerCase();
        this._lengthParmConstraint = SQLDialect.LengthParmConstraint.Ignored;
        this._javaType = clazz;
    }

    public Class<?> getJavaType() {
        return this._javaType;
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public String getSqlTypeName() {
        return this._sqlTypeName;
    }

    public Long getLength(ColumnContext columnContext) {
        return columnContext.getLength();
    }

    public Integer getDecimals(ColumnContext columnContext) {
        return columnContext.getDecimals();
    }

    public String getSqlTypeStringForCreateTable(ColumnContext columnContext) {
        String string = "";
        Long l = this.getLength(columnContext);
        Integer n = this.getDecimals(columnContext);
        if (this._lengthParmConstraint == SQLDialect.LengthParmConstraint.LengthOptional && l != null || this._lengthParmConstraint == SQLDialect.LengthParmConstraint.LengthRequired || this._lengthParmConstraint == SQLDialect.LengthParmConstraint.LengthRequiredDecimalsOptional && n == null) {
            string = "(" + l + ")";
        } else if (this._lengthParmConstraint == SQLDialect.LengthParmConstraint.LengthRequiredDecimalsOptional && n != null || this._lengthParmConstraint == SQLDialect.LengthParmConstraint.LengthRequiredDecimalsRequired) {
            string = "(" + l + "," + n + ")";
        }
        return this._sqlTypeName + string;
    }

    public abstract Object fromStringToSqlObject(String var1);

    public String toString() {
        return this._sqlTypeName + "(" + this._sqlType + ")";
    }
}

