/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.dialect;

import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.properties.jdbc.dialect.DerbyDialect;
import net.java.dev.properties.jdbc.dialect.HsqldbDialect;
import net.java.dev.properties.jdbc.dialect.MysqlDialect;
import net.java.dev.properties.jdbc.dialect.PostgresDialect;
import net.java.dev.properties.jdbc.dialect.SqlType;
import net.java.dev.properties.jdbc.handlers.ColumnContext;

@Singleton
public class SQLDialect {
    private SqlType _defaultStringType;
    private List<SqlType> _types = new ArrayList<SqlType>();

    public SQLDialect() {
        this._types.add(new SqlType(-5, "bigint", BigInteger.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Long.parseLong(string);
            }
        });
        this._types.add(new SqlType(-7, "bit", Boolean.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Byte.parseByte(string);
            }
        });
        this._types.add(new SqlType(16, "boolean", Boolean.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Boolean.valueOf(string);
            }
        });
        this._types.add(new SqlType(1, "char", LengthParmConstraint.LengthOptional, String.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return string;
            }
        });
        this._types.add(new SqlType(91, "date", Date.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                try {
                    long l = new SimpleDateFormat("yyyy-MM-dd").parse(string).getTime();
                    return new Date(l);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        this._types.add(new SqlType(3, "decimal", LengthParmConstraint.LengthRequiredDecimalsRequired, BigDecimal.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return new BigDecimal(string);
            }
        });
        this._types.add(new SqlType(8, "double", Double.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Double.valueOf(string);
            }
        });
        this._types.add(new SqlType(6, "float", Float.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Float.valueOf(string);
            }
        });
        this._types.add(new SqlType(4, "integer", Integer.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Integer.parseInt(string);
            }
        });
        this._types.add(new SqlType(5, "smallint", Short.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Integer.parseInt(string);
            }
        });
        this._types.add(new SqlType(-6, "tinyint", Short.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return Integer.parseInt(string);
            }
        });
        this._types.add(new SqlType(92, "time", Time.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                try {
                    long l = new SimpleDateFormat("HH:mm:ss").parse(string).getTime();
                    return new Time(l);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        this._types.add(new SqlType(93, "timestamp", Timestamp.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                try {
                    long l = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string).getTime();
                    return new Timestamp(l);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        this._defaultStringType = new SqlType(12, "varchar", LengthParmConstraint.LengthOptional, String.class){

            @Override
            public Object fromStringToSqlObject(String string) {
                return string;
            }

            @Override
            public Long getLength(ColumnContext columnContext) {
                Long l = columnContext.getLength();
                if (l == null && SQLDialect.this.varCharRequiresLength()) {
                    l = SQLDialect.this.getVarCharMaxLength();
                }
                return l;
            }
        };
        this._types.add(this._defaultStringType);
    }

    public String getCreateTablePrefix() {
        return "CREATE TABLE";
    }

    public String getCreateTableSQL(String string, List<ColumnContext> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getCreateTablePrefix());
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append(" (");
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = "";
        String string3 = "";
        for (ColumnContext columnContext : list) {
            stringBuilder.append(string3);
            stringBuilder.append(columnContext.getName());
            stringBuilder.append(" ");
            stringBuilder.append(columnContext.getSqlType().getSqlTypeStringForCreateTable(columnContext));
            string3 = ", ";
            if (!columnContext.isPrimaryKey()) continue;
            stringBuilder2.append(string2);
            stringBuilder2.append(columnContext.getName());
            string2 = ", ";
        }
        stringBuilder.append(", PRIMARY KEY(");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean supportsIfExistsOnDropTable() {
        return true;
    }

    public String getDropTableSql(String string, boolean bl) {
        String string2 = "";
        if (bl) {
            string2 = " IF EXISTS";
        }
        return "DROP TABLE " + string + string2;
    }

    public SqlType getType(int n) {
        for (SqlType sqlType : this._types) {
            if (sqlType.getSqlType() != n) continue;
            return sqlType;
        }
        throw new RuntimeException("sql converter for " + n + " not found");
    }

    public SqlType getType(String string) {
        string = string.toLowerCase();
        for (SqlType sqlType : this._types) {
            if (!sqlType.getSqlTypeName().equals(string)) continue;
            return sqlType;
        }
        throw new RuntimeException("sql converter for " + string + " not found");
    }

    public void addConverter(SqlType sqlType) {
        this._types.add(sqlType);
    }

    public SqlType getDefaultStringType() {
        return this._defaultStringType;
    }

    public void setDefaultStringType(SqlType sqlType) {
        this._defaultStringType = sqlType;
    }

    public boolean varCharRequiresLength() {
        return true;
    }

    public long getVarCharMaxLength() {
        return 32672L;
    }

    public static SQLDialect createFromJdbcDriverName(String string) {
        if (string.startsWith("org.postgresql")) {
            return new PostgresDialect();
        }
        if (string.startsWith("org.hsqldb")) {
            return new HsqldbDialect();
        }
        if (string.startsWith("org.apache.derby.jdbc")) {
            return new DerbyDialect();
        }
        if (string.startsWith("com.mysql")) {
            return new MysqlDialect();
        }
        throw new RuntimeException("cannot find a proper sql dialect for jdbc driver " + string);
    }

    public static enum LengthParmConstraint {
        Ignored,
        LengthOptional,
        LengthRequired,
        LengthRequiredDecimalsOptional,
        LengthRequiredDecimalsRequired;

    }
}

