/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import com.google.inject.Inject;
import java.net.URL;
import net.java.dev.properties.jdbc.cache.AbstractSecondLevelCache;
import net.java.dev.properties.jdbc.cache.CacheEntry;
import net.model3.guice.bootstrap.CacheDirectory;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;

public class EHcacheSecondLevelCache
extends AbstractSecondLevelCache {
    Logger logger = LoggerHelper.getLogger();
    Cache _cache;
    @Inject
    CacheDirectory _cacheDirectory;

    @Inject
    private EHcacheSecondLevelCache() {
    }

    public void init(URL uRL) {
        DiskStoreConfiguration diskStoreConfiguration;
        this.logger.debug((Object)"configuring ehcache using {}", (Object)uRL);
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)uRL);
        if (configuration.getDiskStoreConfiguration() == null) {
            diskStoreConfiguration = new DiskStoreConfiguration();
            configuration.addDiskStore(diskStoreConfiguration);
            diskStoreConfiguration.setPath(((Directory)this._cacheDirectory.get()).subDirectory("ehcache").getCanonicalPath());
        }
        diskStoreConfiguration = new CacheManager(configuration);
        String string = "BeanPropertiesSecondLevelCache";
        this._cache = diskStoreConfiguration.getCache(string);
    }

    public void init(Cache cache) {
        this._cache = cache;
    }

    @Override
    public void evictAll() {
        this._cache.removeAll(true);
    }

    @Override
    protected <T extends CacheEntry> T lookupImpl(T t) {
        Element element = this._cache.get(t);
        if (element != null) {
            return (T)((CacheEntry)element.getObjectValue());
        }
        return null;
    }

    @Override
    protected <T extends CacheEntry> void removeImpl(T t) {
        this._cache.remove(t);
    }

    @Override
    protected <T extends CacheEntry> void putImpl(T t) {
        Element element = new Element(t, t);
        int n = (int)((t.getTimeoutValue() - System.currentTimeMillis()) / 1000L);
        element.setTimeToLive(n);
        element.setTimeToIdle(n);
        this._cache.put(element);
    }
}

