/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.jdbc.AbstractLazyLoaderPropertyListener;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.LazyLoader;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.handlers.TypeHandler;

public class DehydratedObject
implements Serializable {
    private Class<?> _type;
    private Object[] _fields;
    private Object[] _primaryKey;
    private boolean _objectOutputStreamProxy;
    private transient boolean _dehydrateIndexedProperties;

    public DehydratedObject() {
    }

    public DehydratedObject(Object object, SessionConfiguration sessionConfiguration, boolean bl, boolean bl2) {
        this._type = object.getClass();
        this._dehydrateIndexedProperties = bl2;
        EntityPersister<?> entityPersister = sessionConfiguration.getPersister(this._type);
        List<TypeHandler<Object>> list = entityPersister.getTypeHandlers();
        this._fields = new Object[list.size()];
        int n = 0;
        for (TypeHandler<Object> typeHandler : list) {
            this._fields[n++] = this.dehydrateProperty(object, typeHandler.getPropertyContext(), sessionConfiguration);
        }
        this._primaryKey = entityPersister.getPrimaryKeyColumnValues(object);
        this._objectOutputStreamProxy = bl;
    }

    public Object[] getPrimaryKey() {
        return this._primaryKey;
    }

    public Object rehydrate(Session session) {
        return this.rehydrate(null, this._type, this._fields, session);
    }

    public Object refreshInstance(Object object, Session session) {
        return this.rehydrate(object, this._type, this._fields, session);
    }

    public Object[] getDehydratedFields() {
        return this._fields;
    }

    public Class<?> getType() {
        return this._type;
    }

    protected Object dehydrateProperty(Object object, IPropertyContext iPropertyContext, SessionConfiguration sessionConfiguration) {
        Object object2;
        Object object3;
        BaseProperty<Object> baseProperty;
        if (!iPropertyContext.isWritable()) {
            return null;
        }
        if (!this._dehydrateIndexedProperties && iPropertyContext.isIndexedProperty()) {
            return null;
        }
        EntityPersister<?> entityPersister = sessionConfiguration.getPersister(iPropertyContext.getType(), false);
        if (iPropertyContext.getReflector().hasBindableProperty() && (baseProperty = iPropertyContext.getProperty(object)) instanceof OnGetListener && (object3 = ((OnGetListener)((Object)baseProperty)).getOnGet()) instanceof LazyLoader && (object2 = ((LazyLoader)object3).getPrimaryKeyValues()) != null) {
            return object2;
        }
        baseProperty = iPropertyContext.getValue(object);
        if (baseProperty == null) {
            return null;
        }
        if (entityPersister != null) {
            if (iPropertyContext.isIndexedProperty()) {
                object3 = new ArrayList();
                for (Object e : (List)((Object)baseProperty)) {
                    object3.add(entityPersister.getPrimaryKeyColumnValues(e));
                }
                return object3;
            }
            return entityPersister.getPrimaryKeyColumnValues(baseProperty);
        }
        return baseProperty;
    }

    private <T> T rehydrate(T t, Class<T> clazz, Object[] objectArray, Session session) {
        final InternalSession internalSession = (InternalSession)session;
        SessionConfiguration sessionConfiguration = internalSession.getConfig();
        final EntityPersister<T> entityPersister = sessionConfiguration.getPersister(clazz, false);
        try {
            final T t2 = t == null ? clazz.newInstance() : t;
            List<TypeHandler<Object>> list = session.getConfig().getPersister(t2.getClass()).getTypeHandlers();
            if (objectArray.length != list.size()) {
                throw new RuntimeException("values != length");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                final IPropertyContext iPropertyContext = list.get(i).getPropertyContext();
                final Class<?> clazz2 = iPropertyContext.getType();
                EntityPersister<?> entityPersister2 = sessionConfiguration.getPersister(clazz2, false);
                if (entityPersister2 == null && object == null) {
                    iPropertyContext.setValue(t2, null);
                    continue;
                }
                if (entityPersister2 != null) {
                    if (!iPropertyContext.getReflector().hasBindableProperty()) {
                        throw new RuntimeException(iPropertyContext + " must be a bindable property (is it instead an @VirtualProperty?");
                    }
                    final BaseProperty<?> baseProperty = iPropertyContext.getProperty(t2);
                    if (iPropertyContext.isIndexedProperty()) {
                        new AbstractLazyLoaderPropertyListener(baseProperty){

                            @Override
                            public void onGetImpl(RProperty<?> rProperty) {
                                final List list = internalSession.fetchIndexedProperty((IndexedProperty)rProperty);
                                BeanContainer.get().doWithEventSuppression(new Runnable(){

                                    @Override
                                    public void run() {
                                        iPropertyContext.setValue(t2, list);
                                    }
                                });
                                entityPersister.getTypeHandler(rProperty.getContext()).merge(internalSession, baseProperty, internalSession.getDirtyListener());
                            }

                            @Override
                            public void propertyChanged(BaseProperty baseProperty2, Object object, Object object2, int n) {
                                super.propertyChanged(baseProperty2, object, object2, n);
                                entityPersister.getTypeHandler(baseProperty2.getContext()).merge(internalSession, baseProperty, internalSession.getDirtyListener());
                            }
                        };
                        continue;
                    }
                    new AbstractLazyLoaderPropertyListener(baseProperty, (Object[])object){

                        @Override
                        public void onGetImpl(RProperty<?> rProperty) {
                            BeanContainer.get().doWithEventSuppression(new Runnable(){

                                @Override
                                public void run() {
                                    Object t = internalSession.fetchByPK(clazz2, this.getPrimaryKeyValues());
                                    iPropertyContext.setValue(t2, t);
                                }
                            });
                        }
                    };
                    continue;
                }
                iPropertyContext.setValue(t2, object);
            }
            return t2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected Object readResolve() {
        if (this._objectOutputStreamProxy) {
            return this.rehydrate(CurrentSession.get());
        }
        return this;
    }
}

