/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import net.java.dev.properties.jdbc.cache.AbstractSecondLevelCache;
import net.java.dev.properties.jdbc.cache.CacheEntry;
import net.java.dev.properties.jdbc.cache.ConcurrentLRUCacheMap;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public class ConcurrentLruMapSecondLevelCache
extends AbstractSecondLevelCache {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private ConcurrentLRUCacheMap<CacheEntry, CacheEntry> _cache = new ConcurrentLRUCacheMap();

    public ConcurrentLruMapSecondLevelCache() {
        this._cache.setMaxEntries(5000);
    }

    @Override
    protected <T extends CacheEntry> T lookupImpl(T t) {
        return (T)this._cache.get(t);
    }

    @Override
    protected <T extends CacheEntry> void putImpl(T t) {
        this._cache.put(t, t);
    }

    @Override
    protected <T extends CacheEntry> void removeImpl(T t) {
        this._cache.remove(t);
    }

    public void setMaximumEntries(int n) {
        this._cache.setMaxEntries(n);
    }

    @Override
    public void evictAll() {
        logger.info("clearing " + this._cache.size() + " entries from the cache");
        this._cache.clear();
    }
}

