/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public class ConcurrentLRUCacheMap<K, V>
implements ConcurrentMap<K, V> {
    static final int DEFAULT_MAX_ENTRIES = 100;
    static final double PERCENT_CLEANUP = 0.05;
    static final int DEFAULT_SEGMENTS = 16;
    static final int CHECK_DURATION = 120000;
    static final Timer timer = new Timer();
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private int _maxEntries;
    private ConcurrentHashMap<K, ValueWrapper<V>> _map;

    public ConcurrentLRUCacheMap() {
        this(100, 16);
    }

    public ConcurrentLRUCacheMap(int n, int n2) {
        this._map = new ConcurrentHashMap((n + 1) * 4 / 3 + 1, 0.75f, n2);
        this._maxEntries = n;
        timer.schedule((TimerTask)new CacheCleaner(), 120000L, 120000L);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        return this._map.replace(k, new ValueWrapper<V>(v), new ValueWrapper<V>(v2));
    }

    @Override
    public V replace(K k, V v) {
        ValueWrapper<V> valueWrapper = this._map.replace(k, new ValueWrapper<V>(v));
        return this.checkRemove(k, valueWrapper);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        ValueWrapper<V> valueWrapper = this._map.putIfAbsent(k, new ValueWrapper<V>(v));
        return this.checkRemove(k, valueWrapper);
    }

    @Override
    public V put(K k, V v) {
        ValueWrapper<V> valueWrapper = this._map.put(k, new ValueWrapper<V>(v));
        return this.checkRemove(k, valueWrapper);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        ValueWrapper<V> valueWrapper = this._map.remove(object);
        return this.checkRemove(object, valueWrapper);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        ValueWrapper<Object> valueWrapper = new ValueWrapper<Object>(object2);
        boolean bl = this._map.remove(object, valueWrapper);
        if (bl) {
            this.removed(object, object2);
        }
        return bl;
    }

    @Override
    public V get(Object object) {
        ValueWrapper<V> valueWrapper = this._map.get(object);
        return valueWrapper == null ? null : (V)valueWrapper.getValue();
    }

    public boolean contains(Object object) {
        return this._map.contains(new ValueWrapper<Object>(object));
    }

    @Override
    public boolean containsKey(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this._map.containsValue(new ValueWrapper<Object>(object));
    }

    @Override
    public Collection<V> values() {
        return new CollectionValueWrapper();
    }

    public Enumeration<V> elements() {
        return new ValueIter();
    }

    public Enumeration<K> keys() {
        return new KeyIter();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConcurrentLRUCacheMap) {
            return ((ConcurrentLRUCacheMap)object)._map.equals(this._map);
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this._map.keySet();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public String toString() {
        return this._map.toString();
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetWrapper();
    }

    final V checkRemove(Object object, ValueWrapper<V> valueWrapper) {
        if (valueWrapper == null) {
            return null;
        }
        Object v = valueWrapper.value;
        this.removed(object, v);
        return v;
    }

    protected void removed(Object object, V v) {
    }

    protected void expiredRemoved(Object object, V v) {
        if (logger.isDebugEnabled()) {
            logger.debug("expiring " + object + "=" + v);
        }
    }

    public int getMaxEntries() {
        return this._maxEntries;
    }

    public void setMaxEntries(int n) {
        this._maxEntries = n;
    }

    static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public void clean() {
        int n = this.getMaxEntries();
        int n2 = this.size();
        if (n2 > n) {
            int n3 = (int)((double)n * 0.05) + (n2 - n);
            logger.debug("Starting to clean " + n3 + " old items from cache(" + n + ") with " + n2 + " items.");
            long l = System.currentTimeMillis();
            Map.Entry[] entryArray = new Map.Entry[]{};
            entryArray = this._map.entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new EntrySetComparator());
            int n4 = entryArray.length;
            for (int i = 0; i < n3; ++i) {
                Map.Entry entry = entryArray[i];
                ValueWrapper valueWrapper = (ValueWrapper)entry.getValue();
                this.remove(entry.getKey());
                if (valueWrapper == null) continue;
                this.expiredRemoved(entry.getKey(), valueWrapper.value);
            }
            logger.debug("Cache(" + n + ") took " + (System.currentTimeMillis() - l) + " ms to clean " + n3 + " items");
        }
    }

    static final class EntrySetComparator<K, V>
    implements Comparator<Map.Entry<K, ValueWrapper<V>>> {
        EntrySetComparator() {
        }

        @Override
        public int compare(Map.Entry<K, ValueWrapper<V>> entry, Map.Entry<K, ValueWrapper<V>> entry2) {
            long l;
            ValueWrapper<V> valueWrapper = entry.getValue();
            long l2 = valueWrapper != null ? valueWrapper.age : -1L;
            ValueWrapper<V> valueWrapper2 = entry2.getValue();
            long l3 = l = valueWrapper2 != null ? valueWrapper2.age : -1L;
            int n = l2 > l ? 1 : (l2 == l ? 0 : -1);
            return n;
        }
    }

    final class CacheCleaner
    extends TimerTask {
        CacheCleaner() {
        }

        @Override
        public void run() {
            try {
                ConcurrentLRUCacheMap.this.clean();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static final class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        Map.Entry<K, ValueWrapper<V>> entry;

        SimpleEntry(Map.Entry<K, ValueWrapper<V>> entry) {
            this.entry = entry;
        }

        @Override
        public V setValue(V v) {
            return this.entry.setValue(new ValueWrapper<V>(v)).value;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            ValueWrapper<V> valueWrapper = this.entry.getValue();
            return valueWrapper == null ? null : (V)valueWrapper.value;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentLRUCacheMap.eq(this.getKey(), entry.getKey()) && ConcurrentLRUCacheMap.eq(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class EntrySetWrapper
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySetWrapper() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIter();
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentLRUCacheMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = ConcurrentLRUCacheMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentLRUCacheMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLRUCacheMap.this.clear();
        }
    }

    final class CollectionValueWrapper
    extends AbstractCollection<V> {
        CollectionValueWrapper() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIter();
        }

        @Override
        public int size() {
            return ConcurrentLRUCacheMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLRUCacheMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentLRUCacheMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(TArray);
        }
    }

    final class EntryIter
    extends Iter
    implements Iterator<Map.Entry<K, V>>,
    Enumeration<Map.Entry<K, V>> {
        EntryIter() {
        }

        @Override
        public Map.Entry<K, V> nextElement() {
            return this.next();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new SimpleEntry(this.advance());
        }
    }

    final class ValueIter
    extends Iter
    implements Iterator<V>,
    Enumeration<V> {
        ValueIter() {
        }

        @Override
        public V nextElement() {
            return this.next();
        }

        @Override
        public V next() {
            ValueWrapper valueWrapper = this.advance().getValue();
            return valueWrapper == null ? null : (Object)valueWrapper.value;
        }
    }

    final class KeyIter
    extends Iter
    implements Iterator<K>,
    Enumeration<K> {
        KeyIter() {
        }

        @Override
        public K nextElement() {
            return this.next();
        }

        @Override
        public K next() {
            return this.advance().getKey();
        }
    }

    abstract class Iter {
        Iterator<Map.Entry<K, ValueWrapper<V>>> iter;
        Map.Entry<K, ValueWrapper<V>> current;

        Iter() {
            this.iter = ConcurrentLRUCacheMap.this._map.entrySet().iterator();
        }

        public void remove() {
            ConcurrentLRUCacheMap.this.remove(this.current.getKey());
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        final Map.Entry<K, ValueWrapper<V>> advance() {
            this.current = this.iter.next();
            return this.current;
        }
    }

    public static final class ValueWrapper<V> {
        static long ageCounter;
        public V value;
        public long age;

        ValueWrapper(V v) {
            this.value = v;
            this.age = ageCounter++;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ValueWrapper)) {
                return false;
            }
            return ConcurrentLRUCacheMap.eq(this.value, ((ValueWrapper)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public V getValue() {
            this.age = ageCounter++;
            return this.value;
        }

        public String toString() {
            return this.value == null ? "null " : this.value.toString();
        }
    }
}

