/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import java.io.Serializable;
import java.util.Arrays;

public abstract class CacheEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] _cacheKeyValues;
    private Long _timeoutValue;
    private final transient Class<?> _type;

    CacheEntry(Class<?> clazz) {
        this._type = clazz;
    }

    public void setCacheKeyValues(Object ... objectArray) {
        if (this._cacheKeyValues != null) {
            throw new RuntimeException("cache key values have already been set");
        }
        int n = this.countElements(objectArray);
        this._cacheKeyValues = new Object[n];
        this.flatten(objectArray, this._cacheKeyValues, 0);
    }

    int countElements(Object object) {
        if (object instanceof Object[]) {
            int n = 0;
            for (Object object2 : (Object[])object) {
                n += this.countElements(object2);
            }
            return n;
        }
        return 1;
    }

    int flatten(Object object, Object[] objectArray, int n) {
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                n = this.flatten(object2, objectArray, n);
            }
            return n;
        }
        objectArray[n] = object;
        return n + 1;
    }

    public Object[] getCacheKeyValues() {
        return this._cacheKeyValues;
    }

    public Long getTimeoutValue() {
        return this._timeoutValue;
    }

    public void setTimeoutValue(Long l) {
        this._timeoutValue = l;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this._cacheKeyValues);
        n = 31 * n + this.getClass().hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        return Arrays.equals(this._cacheKeyValues, cacheEntry._cacheKeyValues);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : this._cacheKeyValues) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(object);
        }
        return this.getClass().getName() + "[" + stringBuilder + "]";
    }

    public Class<?> getType() {
        return this._type;
    }
}

