/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc.cache;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.cache.CacheEntry;
import net.java.dev.properties.jdbc.cache.CacheEntryCollection;
import net.java.dev.properties.jdbc.cache.CacheEntryFetchByPk;
import net.java.dev.properties.jdbc.cache.CacheEntryIndexedProperty;
import net.java.dev.properties.jdbc.cache.CacheEntrySelectAll;
import net.java.dev.properties.jdbc.cache.DehydratedObject;
import net.java.dev.properties.jdbc.cache.SecondLevelCache;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import net.model3.lang.TimeDuration;
import org.slf4j.Logger;

public abstract class AbstractSecondLevelCache
implements SecondLevelCache {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private TimeDuration _cacheEntryTimeout = new TimeDuration("5 minutes");
    @Inject
    SessionConfiguration _sessionConfiguration;

    protected abstract <T extends CacheEntry> T lookupImpl(T var1);

    protected abstract <T extends CacheEntry> void putImpl(T var1);

    protected abstract <T extends CacheEntry> void removeImpl(T var1);

    @Override
    public boolean isFailedFetch(CacheEntryFetchByPk cacheEntryFetchByPk, Session session) {
        return false;
    }

    public SessionConfiguration getSessionConfiguration() {
        return this._sessionConfiguration;
    }

    protected <T extends CacheEntry> T lookup(T t) {
        T t2 = this.lookupImpl(t);
        if (t2 != null) {
            long l = System.currentTimeMillis();
            if (t2.getTimeoutValue() != null && t2.getTimeoutValue() < l) {
                this.removeImpl(t2);
                t2 = null;
            }
        }
        return t2;
    }

    @Override
    public <T> T getEntity(CacheEntryFetchByPk cacheEntryFetchByPk, Session session) {
        Object object = null;
        CacheEntryFetchByPk cacheEntryFetchByPk2 = this.lookup(cacheEntryFetchByPk);
        if (cacheEntryFetchByPk2 != null) {
            try {
                long l = System.currentTimeMillis();
                if (cacheEntryFetchByPk2.getDehydratedObject() != null) {
                    object = cacheEntryFetchByPk2.getDehydratedObject().rehydrate(session);
                    if (logger.isTraceEnabled()) {
                        logger.trace("retrieved " + object + " from cache");
                    }
                } else {
                    this.removeImpl(cacheEntryFetchByPk2);
                }
            }
            catch (Exception exception) {
                this.removeImpl(cacheEntryFetchByPk2);
                object = null;
            }
        }
        return (T)object;
    }

    protected <T> List<T> lookupCollection(CacheEntryCollection cacheEntryCollection) {
        Class clazz = cacheEntryCollection.getElementType();
        ArrayList arrayList = null;
        CacheEntryCollection cacheEntryCollection2 = this.lookup(cacheEntryCollection);
        if (cacheEntryCollection2 != null) {
            arrayList = new ArrayList();
            for (Object[] objectArray : cacheEntryCollection2.getElementKeys()) {
                Object t = CurrentSession.get().fetchByPK(clazz, objectArray);
                if (t == null) continue;
                arrayList.add(t);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("retrieved " + cacheEntryCollection + " from cache");
            }
        }
        return arrayList;
    }

    @Override
    public <T> List<T> getIndexedProperty(IndexedProperty indexedProperty, Session session) {
        CacheEntryIndexedProperty cacheEntryIndexedProperty = new CacheEntryIndexedProperty(indexedProperty.getContext(), indexedProperty.getParent());
        List<T> list = this.lookupCollection(cacheEntryIndexedProperty);
        if (list != null && logger.isTraceEnabled()) {
            logger.trace("retrieved " + cacheEntryIndexedProperty + " from cache");
        }
        return list;
    }

    @Override
    public <T> List<T> getSelectAll(Class<T> clazz, Session session) {
        CacheEntrySelectAll cacheEntrySelectAll = new CacheEntrySelectAll((Class)clazz);
        List<T> list = this.lookupCollection(cacheEntrySelectAll);
        if (list != null && logger.isTraceEnabled()) {
            logger.trace("retrieved " + cacheEntrySelectAll + " from cache");
        }
        return list;
    }

    @Override
    public void evictIndexedProperty(IndexedProperty indexedProperty) {
        this.removeImpl(new CacheEntryIndexedProperty(indexedProperty.getContext(), indexedProperty.getParent()));
    }

    @Override
    public void evictSelectAll(Class<?> clazz) {
        this.removeImpl(new CacheEntrySelectAll((Class)clazz));
    }

    @Override
    public void evictEntity(Class<?> clazz, Object[] objectArray) {
        this.removeImpl(new CacheEntryFetchByPk(clazz, objectArray));
    }

    @Override
    public <T> void cacheIndexedProperty(IndexedProperty<T> indexedProperty, List<T> list) {
        this.put(new CacheEntryIndexedProperty(this._sessionConfiguration, indexedProperty.getContext(), indexedProperty.getParent(), list));
    }

    @Override
    public <T> void cacheSelectAll(Class<T> clazz, List<T> list) {
        this.put(new CacheEntrySelectAll(this._sessionConfiguration, clazz, list));
    }

    @Override
    public void cacheEntity(Object[] objectArray, Object object) {
        CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(object.getClass(), objectArray);
        cacheEntryFetchByPk.setDehydratedObject(new DehydratedObject(object, this.getSessionConfiguration(), false, false));
        this.cacheEntity(cacheEntryFetchByPk);
    }

    @Override
    public void cacheEntity(CacheEntryFetchByPk cacheEntryFetchByPk) {
        this.put(cacheEntryFetchByPk);
    }

    protected <T extends CacheEntry> void put(T t) {
        long l = System.currentTimeMillis();
        TimeDuration timeDuration = this._sessionConfiguration.getPersister(t.getType()).getCacheTimeout();
        if (timeDuration == null) {
            timeDuration = this._cacheEntryTimeout;
        }
        if (timeDuration.inMilliseconds() > 0L) {
            long l2 = l + timeDuration.inMilliseconds();
            t.setTimeoutValue(l2);
            this.putImpl(t);
        }
    }

    public void setCacheEntryTimeout(TimeDuration timeDuration) {
        this._cacheEntryTimeout = timeDuration;
    }
}

