/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.SessionContextStrategy;
import net.java.dev.properties.jdbc.SessionEventAdapter;

@Singleton
public class ThreadLocalSessionContextStrategy
implements SessionContextStrategy {
    private ThreadLocal<InternalSession> _sessionThreadLocal = new ThreadLocal();
    @Inject
    SessionConfiguration _sessionConfiguration;
    @Inject
    Injector _injector;

    @Inject
    private ThreadLocalSessionContextStrategy() {
    }

    public ThreadLocal<InternalSession> getSessionThreadLocal() {
        return this._sessionThreadLocal;
    }

    @Override
    public Session currentSession(boolean bl) {
        if (this._sessionThreadLocal.get() == null && bl) {
            InternalSession internalSession = (InternalSession)this._injector.getInstance(InternalSession.class);
            this._sessionThreadLocal.set(internalSession);
            internalSession.addListener(new SessionEventAdapter(){

                @Override
                public void postClose(Session session) {
                    Session session2 = (Session)ThreadLocalSessionContextStrategy.this._sessionThreadLocal.get();
                    if (session2 != null) {
                        if (session2 == session) {
                            ThreadLocalSessionContextStrategy.this._sessionThreadLocal.set(null);
                        } else {
                            throw new RuntimeException("when using thread local sessions you must call close on the same thread that the session was created on");
                        }
                    }
                }
            });
        }
        return this._sessionThreadLocal.get();
    }

    @Override
    public void close(Session session) {
        if (this._sessionThreadLocal.get() == session) {
            this._sessionThreadLocal.set(null);
        }
    }
}

