/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.container.BeanBindException;
import net.java.dev.properties.events.OnGet;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.AbstractSession;
import net.java.dev.properties.jdbc.BeanQuery;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.JdbcException;
import net.java.dev.properties.jdbc.LazyLoader;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.jdbc.SessionAware;
import net.java.dev.properties.jdbc.SessionEvent;
import net.java.dev.properties.jdbc.SessionEventListener;
import net.java.dev.properties.jdbc.cache.CacheEntryFetchByPk;
import net.java.dev.properties.jdbc.handlers.ManyHandlerInterface;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import net.model3.collections.ListX;
import net.model3.guice.InjectionCompletedListener;
import net.model3.lang.StringX;
import org.slf4j.Logger;

public class SessionImpl
extends AbstractSession
implements InjectionCompletedListener {
    private static final Comparator<Object> classnameSorter = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return object.getClass().getName().compareTo(object2.getClass().getName());
        }
    };
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    final LinkedHashSet<Object> _pendingUpdate = new LinkedHashSet();
    final LinkedHashSet<Object> _pendingDelete = new LinkedHashSet();
    final LinkedHashSet<Object> _pendingInsert = new LinkedHashSet();
    final LinkedHashSet<SessionAware> _sessionAwareObjects = new LinkedHashSet();
    Connection _connection;
    final Stack<Object> _dirtyCheckingSuspensionStack = new Stack();
    final List<Object> _onCommitSecondLevelCacheRemovals = new ArrayList<Object>();
    final List<Object> _onCommitSecondLevelCacheUpdates = new ArrayList<Object>();
    Set<IndexedProperty<?>> _collectionsToInvalidateOnCommit;
    SessionEvent _sessionEvent = new SessionEvent(this);
    IdentityHashMap<Object, Object> _processedForCascades = new IdentityHashMap();
    boolean _dirtyChecking = true;
    Throwable _creationStackTrace;
    private final PropertyListener _propertyListener = new PropertyListener(){
        private static final long serialVersionUID = 2850343050295820679L;

        @Override
        public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
            OnGet onGet;
            if (SessionImpl.this._dirtyCheckingSuspensionStack.size() > 0) {
                return;
            }
            if (object == object2 || object != null && object2 != null && object.equals(object2)) {
                return;
            }
            Object object3 = baseProperty.getParent();
            if (baseProperty instanceof OnGetListener && (onGet = ((OnGetListener)((Object)baseProperty)).getOnGet()) != null && onGet instanceof LazyLoader && ((LazyLoader)onGet).getPrimaryKeyValues() != null) {
                return;
            }
            if (!SessionImpl.this._pendingUpdate.contains(object3)) {
                SessionImpl.this._pendingUpdate.add(object3);
            }
        }
    };

    @Inject
    public SessionImpl() {
        this._creationStackTrace = new Throwable();
        this._creationStackTrace.fillInStackTrace();
    }

    public void injectionComplete() throws Exception {
        for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
            sessionEventListener.postOpen(this);
        }
    }

    public Throwable getCreationStackTrace() {
        return this._creationStackTrace;
    }

    @Override
    public <T> T fetch(Class<T> clazz, String string, Object ... objectArray) {
        Query<T> query = this.select(clazz, string, objectArray);
        T t = null;
        for (T t2 : query) {
            t = t2;
        }
        query.close();
        return t;
    }

    @Override
    public void flush() {
        this._processedForCascades.clear();
        boolean bl = true;
        while (true) {
            int n = this._pendingDelete.size() + this._pendingInsert.size() + this._pendingUpdate.size();
            if (!bl && n == 0) break;
            this.doFlushCycle();
            bl = false;
        }
        this._processedForCascades.clear();
    }

    protected void doFlushCycle() {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>(this._pendingInsert);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(this._pendingUpdate);
            ArrayList<Object> arrayList3 = new ArrayList<Object>(this._pendingDelete);
            ArrayList<SessionAware> arrayList4 = new ArrayList<SessionAware>(this._sessionAwareObjects);
            arrayList.removeAll(this._pendingDelete);
            arrayList2.removeAll(this._pendingDelete);
            arrayList2.removeAll(this._pendingInsert);
            arrayList3.removeAll(this._pendingInsert);
            this._pendingDelete.clear();
            this._pendingInsert.clear();
            this._pendingUpdate.clear();
            logger.trace("flushing inserts={} updates={} deletes={}", new Object[]{arrayList.size(), arrayList2.size(), arrayList3.size()});
            this.flushInserts(arrayList, arrayList4);
            this.flushUpdates(arrayList2, arrayList4);
            this.flushDeletes(arrayList3, arrayList4);
            for (SessionAware sessionAware : arrayList4) {
                sessionAware.flushCompleted();
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new BeanBindException(exception);
        }
    }

    private void flushDeletes(List list, List<SessionAware> list2) {
        for (SessionAware sessionAware : list2) {
            sessionAware.processDeletes();
        }
        this.processFlush(list, new FlushProcessor(){

            @Override
            public void preEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.preDelete(sessionEvent);
            }

            @Override
            public <T> void doEvent(List<T> list, Class<T> clazz) {
                SessionImpl.this._onCommitSecondLevelCacheRemovals.addAll(list);
                SessionImpl.this.getSessionConfiguration().getPersister(clazz).deleteBatch(list, SessionImpl.this);
                SessionImpl.this._pendingDelete.removeAll(list);
            }

            @Override
            public void postEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.postDelete(sessionEvent);
            }
        });
    }

    private void flushUpdates(List list, List<SessionAware> list2) {
        for (SessionAware sessionAware : list2) {
            sessionAware.processUpdates();
        }
        this.processFlush(list, new FlushProcessor(){

            @Override
            public void preEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.preUpdate(sessionEvent);
            }

            @Override
            public <T> void doEvent(List<T> list, Class<T> clazz) {
                SessionImpl.this._onCommitSecondLevelCacheUpdates.addAll(list);
                SessionImpl.this.getSessionConfiguration().getPersister(clazz).updateBatch(list, SessionImpl.this);
                SessionImpl.this._pendingUpdate.removeAll(list);
            }

            @Override
            public void postEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.postUpdate(sessionEvent);
            }
        });
    }

    private void flushInserts(List list, List<SessionAware> list2) {
        for (SessionAware sessionAware : list2) {
            sessionAware.processInserts();
        }
        this.processFlush(list, new FlushProcessor(){

            @Override
            public void preEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.preInsert(sessionEvent);
            }

            @Override
            public <T> void doEvent(List<T> list, Class<T> clazz) {
                SessionImpl.this.getSessionConfiguration().getPersister(clazz).insertBatch(list, SessionImpl.this);
                SessionImpl.this._pendingInsert.removeAll(list);
                SessionImpl.this._pendingUpdate.removeAll(list);
            }

            @Override
            public void postEvent(SessionEvent sessionEvent, SessionEventListener sessionEventListener) {
                sessionEventListener.postInsert(sessionEvent);
            }
        });
    }

    @Override
    public void insert(Object object) {
        if (this.getDirtyChecking()) {
            this.merge(object);
        }
        this.addToCache(object, false);
        if (!this._pendingInsert.contains(object)) {
            this._pendingInsert.add(object);
        }
    }

    @Override
    public void delete(Object object) {
        if (object instanceof SessionAware) {
            this._sessionAwareObjects.remove((SessionAware)object);
        } else {
            this.addToCache(object);
            if (!this._pendingDelete.contains(object)) {
                this._pendingDelete.add(object);
            }
        }
    }

    @Override
    public void update(Object object) {
        if (this.getDirtyChecking()) {
            this.merge(object);
        }
        this.addToCache(object);
        if (!this._pendingUpdate.contains(object)) {
            this._pendingUpdate.add(object);
        }
    }

    @Override
    protected <T> List<T> selectAllImpl(Class<T> clazz) {
        List<T> list = this.select(clazz, null, new Object[0]).getResults();
        return list;
    }

    @Override
    public void merge(Object object) {
        if (!this.getDirtyChecking()) {
            throw new RuntimeException("merge() not allowed if dirty checking is off");
        }
        if (object == null) {
            return;
        }
        if (object instanceof SessionAware) {
            this._sessionAwareObjects.add((SessionAware)object);
        } else {
            EntityPersister<?> entityPersister = this.getSessionConfiguration().getPersister(object.getClass());
            entityPersister.merge(this, object, this.getDirtyListener());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this._sessionAwareObjects.clear();
        this._pendingUpdate.clear();
        this._pendingInsert.clear();
        this._pendingDelete.clear();
    }

    public <T> List<T> selectList(Class<T> clazz, String string, Object ... objectArray) {
        return this.select(clazz, string, objectArray).getResults();
    }

    @Override
    public <T> Query<T> select(Class<T> clazz, String string, Object ... objectArray) {
        EntityPersister<T> entityPersister = this.getSessionConfiguration().getPersister(clazz);
        String string2 = StringX.isNotBlank((String)string) ? entityPersister.getSelectQuery() + " where " + string : entityPersister.getSelectQuery();
        return new BeanQuery<T>(this.getSessionConfiguration(), clazz, string2, objectArray);
    }

    @Override
    protected void commitImpl() {
        if (this._connection != null) {
            try {
                Object[] objectArray;
                for (SessionEventListener object : this.getSessionListeners()) {
                    object.preCommit(this);
                }
                if (this._collectionsToInvalidateOnCommit != null) {
                    for (IndexedProperty indexedProperty : this._collectionsToInvalidateOnCommit) {
                        this.getSecondLevelCache().evictIndexedProperty(indexedProperty);
                    }
                    this._collectionsToInvalidateOnCommit = null;
                }
                this._connection.commit();
                for (Object object : this._onCommitSecondLevelCacheUpdates) {
                    objectArray = this.getOjectToPrimaryKeyMap().get(object);
                    if (objectArray == null) continue;
                    this.getSecondLevelCache().cacheEntity(objectArray, object);
                }
                for (Object object : this._onCommitSecondLevelCacheRemovals) {
                    objectArray = this.getOjectToPrimaryKeyMap().get(object);
                    if (objectArray == null) continue;
                    this.getSecondLevelCache().evictEntity(object.getClass(), objectArray);
                }
                for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
                    sessionEventListener.postCommit(this);
                }
            }
            catch (SQLException sQLException) {
                throw new JdbcException(sQLException);
            }
        }
    }

    @Override
    public void close() {
        for (SessionEventListener object : this.getSessionListeners()) {
            object.preClose(this);
        }
        Connection connection = this._connection;
        this._connection = null;
        if (connection != null) {
            try {
                this.getSessionConfiguration().getConnectionProvider().close(connection);
            }
            catch (Exception exception) {
                throw new JdbcException(exception);
            }
        }
        this.clear();
        for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
            sessionEventListener.postClose(this);
        }
    }

    @Override
    public void popDirtyCheckingSuspension() {
        this._dirtyCheckingSuspensionStack.pop();
    }

    @Override
    public void pushDirtyCheckingSuspension() {
        this._dirtyCheckingSuspensionStack.push(new Object());
    }

    @Override
    public Connection getConnection() {
        if (this._connection == null) {
            try {
                this._connection = this.getSessionConfiguration().getConnectionProvider().open();
            }
            catch (Exception exception) {
                throw new JdbcException(exception);
            }
        }
        return this._connection;
    }

    @Override
    public void refresh(Object object, boolean bl) {
        this.getSessionConfiguration().getPersister(object.getClass()).refresh(this, object, bl);
    }

    @Override
    public <T> List<T> fetchIndexedProperty(IndexedProperty<T> indexedProperty) {
        ManyHandlerInterface manyHandlerInterface = (ManyHandlerInterface)((Object)this.getSessionConfiguration().getPersister(indexedProperty.getParent().getClass()).getTypeHandler(indexedProperty.getContext()));
        return manyHandlerInterface.getManyEntities(indexedProperty);
    }

    @Override
    public PropertyListener getDirtyListener() {
        return this._propertyListener;
    }

    private void processFlush(List<Object> list, FlushProcessor flushProcessor) {
        Collections.sort(list, classnameSorter);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = list.size();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            Object object2 = list.get(i);
            Object object3 = null;
            if (i + 1 < n) {
                object3 = list.get(i + 1);
            }
            arrayList.add(object2);
            if (object3 == null || !object2.getClass().equals(object3.getClass())) {
                for (Object e : arrayList) {
                    this._sessionEvent.setBean(e);
                    for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
                        flushProcessor.preEvent(this._sessionEvent, sessionEventListener);
                    }
                }
                flushProcessor.doEvent(arrayList, object2.getClass());
                for (Object e : arrayList) {
                    for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
                        this._sessionEvent.setBean(e);
                        flushProcessor.postEvent(this._sessionEvent, sessionEventListener);
                    }
                }
                arrayList.clear();
            }
            object = object2;
        }
    }

    Set<IndexedProperty<?>> getCollectionsToInvalidateOnCommit() {
        if (this._collectionsToInvalidateOnCommit == null) {
            this._collectionsToInvalidateOnCommit = new HashSet();
        }
        return this._collectionsToInvalidateOnCommit;
    }

    @Override
    public void addListener(SessionEventListener sessionEventListener) {
        this.getSessionListeners().add(sessionEventListener);
    }

    @Override
    public void evictCollectionFromSecondLevelCacheOnCommit(IndexedProperty<?> indexedProperty) {
        this.getCollectionsToInvalidateOnCommit().add(indexedProperty);
    }

    @Override
    public void addToProcessedForCascades(Object object) {
        this._processedForCascades.put(object, object);
    }

    @Override
    public void setDirtyChecking(boolean bl) {
        this._dirtyChecking = bl;
    }

    @Override
    public boolean getDirtyChecking() {
        return this._dirtyChecking;
    }

    @Override
    protected <T> T fetchByPKImpl(EntityPersister<T> entityPersister, Object ... objectArray) {
        T t = entityPersister.findByPK(this, objectArray);
        return t;
    }

    @Override
    public boolean hasBeenProcessedForCascades(Object object) {
        return this._processedForCascades.containsKey(object);
    }

    @Override
    public <T> List<T> batchFetch(Class<T> clazz, List<Object> list) {
        Object object;
        List list2 = ListX.create();
        EntityPersister<T> entityPersister = this.getSessionConfiguration().getPersister(clazz);
        int n = entityPersister.getPrimaryKeyColumns().size();
        Object[] objectArray = new Object[n];
        List list3 = ListX.create();
        for (Object objectArray2 : list) {
            if (objectArray2 instanceof Object[]) {
                object = (Object[])objectArray2;
            } else if (n == 1) {
                object = objectArray;
                object[0] = objectArray2;
            } else {
                throw new RuntimeException("expecting " + n + " keys and passed only 1");
            }
            if (n != objectArray.length) {
                throw new RuntimeException("expecting " + n + " keys and passed " + objectArray.length);
            }
            CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(clazz, objectArray);
            Object t = this.fetchFromCache(cacheEntryFetchByPk, true);
            if (t == null) {
                list3.add(objectArray);
                continue;
            }
            list2.add(t);
        }
        logger.warn("batchFetch() using un-optimized query TODOoptimize");
        for (Object[] objectArray2 : list3) {
            object = this.fetchByPK(clazz, objectArray2);
            if (object == null) continue;
            list2.add(object);
        }
        return list2;
    }

    static interface FlushProcessor {
        public void preEvent(SessionEvent var1, SessionEventListener var2);

        public <T> void doEvent(List<T> var1, Class<T> var2);

        public void postEvent(SessionEvent var1, SessionEventListener var2);
    }
}

