/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.ConnectionProvider;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.NullForeignKeyChecker;
import net.java.dev.properties.jdbc.PersistenceStrategy;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.SessionEventListener;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.dialect.SQLDialect;
import net.java.dev.properties.jdbc.handlers.SingleEntityHandler;
import net.java.dev.properties.jdbc.handlers.TableCreator;
import net.java.dev.properties.jdbc.handlers.TableDropper;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandlerFactory;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import net.model3.lang.ExceptionPropagator;
import org.slf4j.Logger;

@Singleton
public class SessionConfigurationImpl
implements SessionConfiguration {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private TypeHandlerFactory _typeHandlerFactory;
    private final Map<Class, EntityPersister<?>> _persistersMap = new LinkedHashMap();
    private final List<SessionEventListener> _listeners = new ArrayList<SessionEventListener>();
    private final List<Class<? extends SessionEventListener>> _listenerClasses = new ArrayList<Class<? extends SessionEventListener>>();
    @Inject
    Injector _injector;
    @Inject
    NullForeignKeyChecker _nullForeignKeyChecker;
    @Inject
    ConnectionProvider _connectionProvider;
    @Inject
    PersistenceStrategy _persistenceStrategy;
    @Inject
    SQLDialect _sqlDialect;
    List<SessionEventListener> _sessionListeners;

    @Inject
    private SessionConfigurationImpl() {
    }

    @Override
    public SQLDialect getSqlDialect() {
        return this._sqlDialect;
    }

    @Override
    public <T> EntityPersister<T> addClass(Class<T> clazz) {
        logger.debug("adding entity persister for {}", clazz);
        try {
            EntityPersister<T> entityPersister = this.getPersister(clazz, false);
            if (entityPersister != null) {
                return entityPersister;
            }
            IBeanContext iBeanContext = BeanContainer.get().getContext(clazz);
            entityPersister = new EntityPersister<T>(clazz, iBeanContext, this);
            this._persistersMap.put(clazz, entityPersister);
            this.getTypeHandlerFactory().addTypeSpecific(new SingleEntityHandler<T>(entityPersister));
            entityPersister.setTableName(iBeanContext.getTableName());
            return entityPersister;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((String)("failure adding " + clazz), (Throwable)exception);
        }
    }

    @Override
    public Collection<EntityPersister<?>> getPersisters() {
        return this._persistersMap.values();
    }

    @Override
    public <T> EntityPersister<T> getPersister(Class<T> clazz) {
        return this.getPersister(clazz, true);
    }

    @Override
    public <T> EntityPersister<T> getPersister(Class<T> clazz, boolean bl) {
        EntityPersister<?> entityPersister = this._persistersMap.get(clazz);
        if (entityPersister == null && bl) {
            throw new RuntimeException("could not find persister for " + clazz.getName());
        }
        return entityPersister;
    }

    @Override
    public boolean isPersistable(Class<?> clazz) {
        boolean bl = this._persistersMap.containsKey(clazz);
        return bl;
    }

    @Override
    public List<IPropertyContext> getPrimaryKeyContexts(EntityPersister entityPersister) {
        ArrayList<IPropertyContext> arrayList = new ArrayList<IPropertyContext>();
        List<TypeHandler<Object>> list = entityPersister.getTypeHandlers();
        for (TypeHandler<Object> typeHandler : list) {
            if (!typeHandler.getOrmContext().isPrimaryKey()) continue;
            arrayList.add(typeHandler.getPropertyContext());
        }
        Collections.sort(arrayList, new Comparator<IPropertyContext>(){

            @Override
            public int compare(IPropertyContext iPropertyContext, IPropertyContext iPropertyContext2) {
                return iPropertyContext.getOrmContext().getCompositeKeySequence() - iPropertyContext2.getOrmContext().getCompositeKeySequence();
            }
        });
        return arrayList;
    }

    @Override
    public List<SessionEventListener> getListeners() {
        return this._listeners;
    }

    @Override
    public List<Class<? extends SessionEventListener>> getListenerClasses() {
        return this._listenerClasses;
    }

    public void addClassesAndCreateTables(boolean bl, boolean bl2, Class<?> ... classArray) {
        EntityPersister[] entityPersisterArray = new EntityPersister[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            entityPersisterArray[i] = this.addClass(classArray[i]);
        }
        for (EntityPersister entityPersister : entityPersisterArray) {
            entityPersister.createTable(bl);
        }
    }

    @Override
    public Map<String, TableCreator> getTableCreators() {
        HashMap<String, TableCreator> hashMap = new HashMap<String, TableCreator>();
        for (EntityPersister<?> entityPersister : this.getPersisters()) {
            hashMap.put(entityPersister.getTableName(), entityPersister);
            for (int i = 0; i < entityPersister.getTypeHandlers().size(); ++i) {
                TableCreator tableCreator;
                TypeHandler<Object> typeHandler = entityPersister.getTypeHandlers().get(i);
                if (!(typeHandler instanceof TableCreator) || hashMap.containsKey((tableCreator = (TableCreator)((Object)typeHandler)).getTableName())) continue;
                hashMap.put(tableCreator.getTableName(), tableCreator);
            }
        }
        return hashMap;
    }

    @Override
    public void createDatabaseTables() {
        for (TableCreator tableCreator : this.getTableCreators().values()) {
            tableCreator.createTable();
        }
    }

    @Override
    public void clearDatabaseTables() {
        for (TableCreator tableCreator : this.getTableCreators().values()) {
            new UpdateQuery("DELETE FROM " + tableCreator.getTableName()).execute();
        }
    }

    public void init() {
        for (EntityPersister<?> entityPersister : this._persistersMap.values()) {
            entityPersister.init();
        }
    }

    @Override
    public void dropDatabaseTables() {
        for (TableCreator tableCreator : this.getTableCreators().values()) {
            if (tableCreator instanceof TableDropper) {
                ((TableDropper)((Object)tableCreator)).dropTable();
                continue;
            }
            String string = this._sqlDialect.getDropTableSql(tableCreator.getTableName(), true);
            new UpdateQuery(string).execute();
        }
    }

    public void testQueries() {
        block6: {
            logger.info("testing queries started");
            for (EntityPersister<?> object : this.getPersisters()) {
                object.init();
            }
            Object object = null;
            try {
                object = this._connectionProvider.open();
                for (EntityPersister<?> exception2 : this.getPersisters()) {
                    exception2.testQueries((Connection)object);
                }
            }
            catch (Exception exception) {
                logger.warn("error testing queries", (Throwable)exception);
                if (object == null) break block6;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    logger.warn("error closing connection", (Throwable)exception2);
                }
            }
        }
        logger.debug("testing queries completed");
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this._connectionProvider;
    }

    @Override
    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this._connectionProvider = connectionProvider;
    }

    @Override
    public TypeHandlerFactory getTypeHandlerFactory() {
        if (this._typeHandlerFactory == null) {
            this._typeHandlerFactory = new TypeHandlerFactory(this._injector, this);
        }
        return this._typeHandlerFactory;
    }

    @Override
    public PersistenceStrategy getPersistenceStrategy() {
        return this._persistenceStrategy;
    }

    public void setPersistenceStrategy(PersistenceStrategy persistenceStrategy) {
        this._persistenceStrategy = persistenceStrategy;
    }

    public void setSqlDialect(SQLDialect sQLDialect) {
        this._sqlDialect = sQLDialect;
    }

    @Override
    public NullForeignKeyChecker getNullForeignKeyChecker() {
        return this._nullForeignKeyChecker;
    }
}

