/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.java.dev.properties.jdbc.AbstractQuery;
import net.java.dev.properties.jdbc.JdbcException;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import net.model3.lang.NotImplementedException;
import org.slf4j.Logger;

public abstract class SelectQuery<T>
extends AbstractQuery
implements Query<T>,
List<T> {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private ResultSet _jdbcResultSet;
    private List<T> _responses;
    private Iterator<T> _iterator;
    private Boolean _resultsProcessedAsList;

    public SelectQuery(String string) {
        super(string, null);
    }

    public SelectQuery(String string, Connection connection) {
        super(string, connection);
    }

    public SelectQuery(String string, Connection connection, Object ... objectArray) {
        super(string, connection);
        this.setArguments(objectArray);
    }

    @Override
    protected void closeImpl() {
        try {
            if (this._jdbcResultSet != null) {
                this._jdbcResultSet.close();
            }
        }
        catch (Exception exception) {
            logger.warn("error closing result set", (Throwable)exception);
        }
        super.closeImpl();
    }

    @Override
    public Iterator<T> iterator() {
        if (this._iterator == null && this._resultsProcessedAsList == null) {
            if (this.getSuccess() == null) {
                this.execute();
            }
            this._resultsProcessedAsList = false;
            this._iterator = new Iterator<T>(){
                private T _next;
                private IteratorState _state = IteratorState.Unknown;

                @Override
                public boolean hasNext() {
                    this.determineState();
                    return this._state == IteratorState.HasNext;
                }

                @Override
                public T next() {
                    this.determineState();
                    if (this._state == IteratorState.EndOfResultSet) {
                        throw new JdbcException("end of result set already reached");
                    }
                    this._state = IteratorState.Unknown;
                    Object t = this._next;
                    this._next = null;
                    return t;
                }

                void determineState() {
                    if (this._state == IteratorState.Unknown) {
                        try {
                            boolean bl = SelectQuery.this._jdbcResultSet.next();
                            if (bl) {
                                this._next = SelectQuery.this.processRow(SelectQuery.this._jdbcResultSet);
                                this._state = IteratorState.HasNext;
                            } else {
                                SelectQuery.this.close();
                                this._state = IteratorState.EndOfResultSet;
                            }
                        }
                        catch (Exception exception) {
                            throw new JdbcException(exception);
                        }
                    }
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
        if (this._resultsProcessedAsList.booleanValue()) {
            return this.getResults().iterator();
        }
        return this._iterator;
    }

    protected abstract T processRow(ResultSet var1) throws SQLException;

    @Override
    public final T getResult() {
        T t = null;
        Iterator<T> iterator = this.iterator();
        if (iterator.hasNext()) {
            t = iterator.next();
        }
        this.close();
        return t;
    }

    @Override
    public List<T> getResults() {
        if (this._resultsProcessedAsList == null) {
            if (this.getSuccess() == null) {
                this.execute();
            }
            this._resultsProcessedAsList = true;
            this._responses = new ArrayList<T>();
            try {
                while (this._jdbcResultSet.next()) {
                    this._responses.add(this.processRow(this._jdbcResultSet));
                }
                this.close();
            }
            catch (SQLException sQLException) {
                throw new JdbcException(sQLException);
            }
        }
        if (this._resultsProcessedAsList.booleanValue()) {
            return this._responses;
        }
        throw new RuntimeException("results were already processed as an iterator");
    }

    @Override
    protected void postQuery() throws SQLException {
        this._jdbcResultSet = this.getStatement().getResultSet();
    }

    @Override
    public boolean contains(Object object) {
        return this.getResults().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getResults().containsAll(collection);
    }

    @Override
    public T get(int n) {
        return this.getResults().get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getResults().indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.getResults().isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getResults().lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getResults().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.getResults().listIterator(n);
    }

    @Override
    public T remove(int n) {
        return null;
    }

    @Override
    public int size() {
        return this.getResults().size();
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.getResults().subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.getResults().toArray();
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        return this.getResults().toArray(UArray);
    }

    @Override
    public void add(int n, T t) {
        this.getResults().add(n, t);
    }

    @Override
    public boolean add(T t) {
        return this.getResults().add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.getResults().addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        return this.getResults().addAll(n, collection);
    }

    @Override
    public void clear() {
        this.getResults().clear();
    }

    @Override
    public boolean remove(Object object) {
        return this.getResults().remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getResults().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getResults().retainAll(collection);
    }

    @Override
    public T set(int n, T t) {
        return this.getResults().set(n, t);
    }

    private static enum IteratorState {
        Unknown,
        HasNext,
        EndOfResultSet;

    }
}

