/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.SelectQuery;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class PostgresIdGenerator {
    private static final Log logger = LogHelper.getLog();
    private final int _numberOfNextvalsToPreload;
    private final ConcurrentLinkedQueue<Long> _preCalculatedGuidsStack = new ConcurrentLinkedQueue();
    private String _nextvalSql;
    private String _sequenceName = "guid";

    public PostgresIdGenerator() {
        this(20);
    }

    public PostgresIdGenerator(int n) {
        this._numberOfNextvalsToPreload = n;
    }

    public long getNextIdValue() {
        Long l = null;
        while (l == null) {
            this.reloadQueue();
            l = this._preCalculatedGuidsStack.poll();
        }
        return l;
    }

    void reloadQueue() {
        if (this._preCalculatedGuidsStack.size() > 0) {
            return;
        }
        logger.trace((Object)"reloading queue");
        new SelectQuery<Object>(this.getNextvalSql(), CurrentSession.get().getConnection()){

            @Override
            protected Void processRow(ResultSet resultSet) throws SQLException {
                for (int i = 1; i <= PostgresIdGenerator.this._numberOfNextvalsToPreload; ++i) {
                    PostgresIdGenerator.this._preCalculatedGuidsStack.add(resultSet.getLong(i));
                }
                return null;
            }
        }.getResults();
        logger.trace((Object)"queue reload complete");
    }

    public void setSequenceName(String string) {
        this._sequenceName = string;
    }

    String getNextvalSql() {
        if (this._nextvalSql == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select ");
            for (int i = 0; i < this._numberOfNextvalsToPreload; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("nextval('");
                stringBuilder.append(this._sequenceName);
                stringBuilder.append("')");
            }
            this._nextvalSql = stringBuilder.toString();
        }
        return this._nextvalSql;
    }
}

