/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.container.BeanBindException;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.OnGet;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.AbstractLazyLoaderPropertyListener;
import net.java.dev.properties.jdbc.CascadeHandler;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.LazyLoader;
import net.java.dev.properties.jdbc.NullForeignKeyChecker;
import net.java.dev.properties.jdbc.QueryStringBuilder;
import net.java.dev.properties.jdbc.SelectQuery;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.SessionEvent;
import net.java.dev.properties.jdbc.SessionEventListener;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.dialect.SQLDialect;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.java.dev.properties.jdbc.handlers.SingleEntityHandler;
import net.java.dev.properties.jdbc.handlers.TableCreator;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import net.java.dev.properties.util.Utils;
import net.model3.collections.ListX;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import org.slf4j.Logger;

public class EntityPersister<T>
implements TableCreator {
    private final Logger logger = BeanPropsLoggerHelper.getLogger();
    final SessionConfiguration _sessionConfiguration;
    String _tableName;
    final IBeanContext _beanContext;
    final Class<T> _beanClass;
    Map<IPropertyContext, TypeHandler<Object>> _propertyContextToHandlerMap;
    List<TypeHandler<Object>> _typeHandlers;
    List<CascadeHandler> _cascadeHandlers;
    List<ColumnContext> _columns;
    List<ColumnContext> _insertColumns;
    String _insertQuery;
    String _deleteQuery;
    String _updateQuery;
    String _updateQuerySetClause;
    String _selectPkQuery;
    String _selectQuery;
    List<TypeHandler<Object>> _primaryKeyHandlers;
    List<Class<?>> _primaryKeyColumnTypes;
    List<ColumnContext> _primaryKeyColumns;
    List<IPropertyContext> _primaryKeyPropertyContexts;
    List<IPropertyContext> _propertyContexts;
    boolean _addToCache = true;

    public EntityPersister(Class<T> clazz, IBeanContext iBeanContext, SessionConfiguration sessionConfiguration) {
        this._beanClass = clazz;
        this._beanContext = iBeanContext;
        this._tableName = iBeanContext.getTableName();
        this._sessionConfiguration = sessionConfiguration;
    }

    public void setAddToCache(boolean bl) {
        this._addToCache = bl;
    }

    public TypeHandler getTypeHandler(IPropertyContext iPropertyContext) {
        TypeHandler<Object> typeHandler = this.getPropertyMapping().get(iPropertyContext);
        if (typeHandler == null) {
            typeHandler = this.createHandlerForPropertyContext(iPropertyContext);
            if (typeHandler == null) {
                throw new RuntimeException("unable to find typeHandler for " + iPropertyContext.getName());
            }
            this._propertyContextToHandlerMap.put(iPropertyContext, typeHandler);
        }
        return typeHandler;
    }

    Map<IPropertyContext, TypeHandler<Object>> getPropertyMapping() {
        this.initPropertyContextToHandlerMap();
        return this._propertyContextToHandlerMap;
    }

    public void init() {
        this.initPropertyContextToHandlerMap();
        this.getColumns();
        this.getInsertQuery();
        this.getSelectQuery();
        this.getUpdateQuery();
        this.getSelectPkQuery();
    }

    private void initPropertyContextToHandlerMap() {
        if (this._propertyContextToHandlerMap == null) {
            this._propertyContextToHandlerMap = new HashMap<IPropertyContext, TypeHandler<Object>>();
            this._typeHandlers = new ArrayList<TypeHandler<Object>>();
            for (IPropertyContext iPropertyContext : this._beanContext.getProperties()) {
                if (iPropertyContext.isTransient() || iPropertyContext.getOrmContext() == null) continue;
                TypeHandler<Object> typeHandler = this.createHandlerForPropertyContext(iPropertyContext);
                this._propertyContextToHandlerMap.put(iPropertyContext, typeHandler);
                this._typeHandlers.add(typeHandler);
            }
        }
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public List<TypeHandler<Object>> getPrimaryKeyHandlers() {
        if (this._primaryKeyHandlers == null) {
            ArrayList<TypeHandler<Object>> arrayList = new ArrayList<TypeHandler<Object>>();
            for (IPropertyContext iPropertyContext : this.getPrimaryKeyContexts()) {
                TypeHandler typeHandler = this.getTypeHandler(iPropertyContext);
                arrayList.add(typeHandler);
            }
            this._primaryKeyHandlers = arrayList;
        }
        return this._primaryKeyHandlers;
    }

    public List<Class<?>> getPrimaryKeyColumnTypes() {
        if (this._primaryKeyColumnTypes == null) {
            List list = ListX.create();
            for (TypeHandler<Object> typeHandler : this.getPrimaryKeyHandlers()) {
                if (typeHandler instanceof SingleEntityHandler) {
                    EntityPersister<?> entityPersister = this._sessionConfiguration.getPersister(typeHandler.getPropertyContext().getType());
                    list.addAll(entityPersister.getPrimaryKeyColumnTypes());
                    continue;
                }
                list.add(typeHandler.getPropertyContext().getType());
            }
            this._primaryKeyColumnTypes = list;
        }
        return this._primaryKeyColumnTypes;
    }

    TypeHandler<Object> createHandlerForPropertyContext(IPropertyContext iPropertyContext) {
        TypeHandler<Object> typeHandler = this._sessionConfiguration.getTypeHandlerFactory().createHandlerForPropertyContext(this, iPropertyContext);
        return typeHandler;
    }

    public String getInsertQuery() {
        if (this._insertQuery == null) {
            this._insertQuery = this.createInsertSql(this._tableName);
        }
        return this._insertQuery;
    }

    public String createInsertSql(String string) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.append("insert into ");
        queryStringBuilder.append(string);
        queryStringBuilder.append(" (");
        queryStringBuilder.appendHandlerColumns(this.getInsertColumns(), ", ");
        queryStringBuilder.append(" ) values ( ");
        String string2 = "";
        for (int i = 0; i < queryStringBuilder.getColumnCount(); ++i) {
            queryStringBuilder.append(string2);
            queryStringBuilder.append("?");
            string2 = ", ";
        }
        queryStringBuilder.append(" )");
        return queryStringBuilder.getSql();
    }

    public void insertQuery(PreparedStatement preparedStatement, Object object) throws SQLException {
        EntityPersister.processPreparedStatementHandlers(object, preparedStatement, this.getInsertColumns());
    }

    private void processCascades(Object object) {
    }

    private void appendWherePK(QueryStringBuilder queryStringBuilder) {
        queryStringBuilder.append(" where ");
        String string = "";
        queryStringBuilder.appendHandlerColumns(this.getPrimaryKeyColumns(), "= ?", " and ");
    }

    public String getPKWhereClause() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ColumnContext columnContext : this.getPrimaryKeyColumns()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(columnContext.getName());
            stringBuilder.append(" = ?");
        }
        return stringBuilder.toString();
    }

    public String getDeleteQuery() {
        if (this._deleteQuery == null) {
            this._deleteQuery = this.createDeleteSql(this._tableName);
        }
        return this._deleteQuery;
    }

    public String createDeleteSql(String string) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.append("delete from ");
        queryStringBuilder.append(string);
        queryStringBuilder.append(" ");
        this.appendWherePK(queryStringBuilder);
        return queryStringBuilder.getSql();
    }

    public void deleteQuery(PreparedStatement preparedStatement, Object object) throws SQLException {
        EntityPersister.processPreparedStatementHandlers(object, preparedStatement, this.getPrimaryKeyColumns());
    }

    public static void processPreparedStatementHandlers(Object object, PreparedStatement preparedStatement, List<ColumnContext> list) throws SQLException {
        EntityPersister.processPreparedStatementHandlers(object, preparedStatement, list, 0);
    }

    public static void processPreparedStatementHandlers(Object object, PreparedStatement preparedStatement, List<ColumnContext> list, int n) throws SQLException {
        int n2 = n + 1;
        for (ColumnContext columnContext : list) {
            TypeHandler typeHandler = columnContext.getTypeHandler();
            Object object2 = columnContext.getColumnValue(object);
            int n3 = columnContext.getColumnIndexInTypeHandler();
            typeHandler.mapColumnToPreparedStatement(object2, n3, preparedStatement, n2);
            ++n2;
        }
    }

    private String getUpdateQuery() {
        if (this._updateQuery == null) {
            this._updateQuery = this.createUpdateSql(this._tableName);
        }
        return this._updateQuery;
    }

    public String createUpdateSql(String string) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.append("update ");
        queryStringBuilder.append(string);
        queryStringBuilder.append(" set ");
        queryStringBuilder.appendHandlerColumns(this.getUpdateColumns(), " = ? ", ", ");
        this.appendWherePK(queryStringBuilder);
        return queryStringBuilder.getSql();
    }

    private boolean isPrimaryKey(IPropertyContext iPropertyContext) {
        for (TypeHandler<Object> typeHandler : this.getPrimaryKeyHandlers()) {
            if (typeHandler.getPropertyContext() != iPropertyContext) continue;
            return true;
        }
        return false;
    }

    public void updateQuery(PreparedStatement preparedStatement, Object object) throws SQLException {
        EntityPersister.processPreparedStatementHandlers(object, preparedStatement, this.getUpdateColumns());
        EntityPersister.processPreparedStatementHandlers(object, preparedStatement, this.getPrimaryKeyColumns(), this.getUpdateColumns().size());
    }

    public void insertBatch(List<T> list, InternalSession internalSession) {
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t;
            final T t2 = t = iterator.next();
            new UpdateQuery(this.getInsertQuery(), internalSession.getConnection()){

                @Override
                protected void prepareQuery() throws SQLException {
                    EntityPersister.this.insertQuery(this.getStatement(), t2);
                }
            }.execute();
        }
        this.processListForCascades(list, internalSession);
    }

    private void processListForCascades(List<T> list, InternalSession internalSession) {
        for (T t : list) {
            if (internalSession.hasBeenProcessedForCascades(t)) continue;
            internalSession.addToProcessedForCascades(t);
            this.processForCascades(internalSession, t);
        }
    }

    private void processForCascades(InternalSession internalSession, Object object) {
        for (CascadeHandler cascadeHandler : this.getCascadeHandlers()) {
            cascadeHandler.processCascade(internalSession, object);
        }
    }

    void deleteBatch(List<T> list, Session session) {
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t;
            final T t2 = t = iterator.next();
            new UpdateQuery(this.getDeleteQuery(), session.getConnection()){

                @Override
                protected void prepareQuery() throws SQLException {
                    EntityPersister.this.deleteQuery(this.getStatement(), t2);
                }
            }.execute();
        }
    }

    void updateBatch(List<T> list, InternalSession internalSession) {
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t;
            final T t2 = t = iterator.next();
            new UpdateQuery(this.getUpdateQuery(), internalSession.getConnection()){

                @Override
                protected void prepareQuery() throws SQLException {
                    EntityPersister.this.updateQuery(this.getStatement(), t2);
                }
            }.execute();
        }
        this.processListForCascades(list, internalSession);
    }

    @Override
    public void createTable() {
        this.createTable(false);
    }

    public void createTable(boolean bl) {
        try {
            SQLDialect sQLDialect = this.getSessionConfiguration().getSqlDialect();
            List list = ListX.create();
            for (ColumnContext columnContext : this.getColumns()) {
                if (list.contains(columnContext)) continue;
                list.add(columnContext);
            }
            String string = this.getCreateTableSql();
            this.logger.debug("creating table\n     {}", (Object)string);
            new UpdateQuery(string).execute();
        }
        catch (Exception exception) {
            if (bl) {
                return;
            }
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getCreateTableSql() {
        SQLDialect sQLDialect = this.getSessionConfiguration().getSqlDialect();
        List list = ListX.create();
        for (ColumnContext columnContext : this.getColumns()) {
            if (list.contains(columnContext)) continue;
            list.add(columnContext);
        }
        return sQLDialect.getCreateTableSQL(this.getTableName(), list);
    }

    public Object[] getPrimaryKeyColumnValues(T t) {
        Object[] objectArray = new Object[this.getPrimaryKeyColumns().size()];
        int n = 0;
        for (TypeHandler<Object> typeHandler : this.getPrimaryKeyHandlers()) {
            OnGet onGet;
            RProperty rProperty;
            Object[] objectArray2;
            if (t == null) {
                NullForeignKeyChecker nullForeignKeyChecker = this._sessionConfiguration.getNullForeignKeyChecker();
                for (ColumnContext columnContext : typeHandler.getColumns()) {
                    objectArray2 = columnContext.getSqlType().getJavaType();
                    objectArray[n] = nullForeignKeyChecker.getNullValue((Class<?>)objectArray2);
                    ++n;
                }
                continue;
            }
            boolean bl = false;
            if (typeHandler.getPropertyContext().getReflector().hasBindableProperty() && (rProperty = (RProperty)typeHandler.getPropertyContext().getProperty(t)) instanceof OnGetListener && (onGet = ((OnGetListener)((Object)rProperty)).getOnGet()) instanceof LazyLoader && (objectArray2 = ((LazyLoader)onGet).getPrimaryKeyValues()) != null) {
                System.arraycopy(objectArray2, 0, objectArray, n, typeHandler.getColumns().size());
                bl = true;
                n += typeHandler.getColumns().size();
            }
            if (bl) continue;
            if (typeHandler instanceof SingleEntityHandler) {
                RProperty rProperty2 = (RProperty)typeHandler.getPropertyContext().getProperty(t);
                Object[] objectArray3 = ((SingleEntityHandler)typeHandler).getForeignPersister().getPrimaryKeyColumnValues(rProperty2.get());
                System.arraycopy(objectArray3, 0, objectArray, n, objectArray3.length);
                n += objectArray3.length;
                continue;
            }
            int n2 = typeHandler.getColumns().size();
            for (int i = 0; i < n2; ++i) {
                objectArray[n] = typeHandler.getColumnValue(t, i);
                ++n;
            }
        }
        return objectArray;
    }

    public String getSelectPkQuery() {
        if (this._selectPkQuery == null) {
            QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
            queryStringBuilder.append(this.getSelectQuery());
            this.appendWherePK(queryStringBuilder);
            this._selectPkQuery = queryStringBuilder.getSql();
        }
        return this._selectPkQuery;
    }

    public String getSelectQuery() {
        if (this._selectQuery == null) {
            this._selectQuery = this.createSelectSql(this._tableName);
        }
        return this._selectQuery;
    }

    public String createSelectSql(String string) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.append("select ");
        queryStringBuilder.appendColumns(this.getColumns(), ", ");
        queryStringBuilder.append(" from ");
        queryStringBuilder.append(string);
        return queryStringBuilder.toString();
    }

    public String getSelectFields(String string) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder();
        queryStringBuilder.appendColumns(this.getColumns(), string, "", ", ");
        return queryStringBuilder.toString();
    }

    public List<T> createListFromResultSet(ResultSet resultSet) throws SQLException {
        return this.createListFromResultSet(resultSet, 0, Integer.MAX_VALUE);
    }

    public List<T> createListFromResultSet(ResultSet resultSet, int n, int n2) throws SQLException {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (n > 0) {
            resultSet.next();
            --n;
        }
        while (resultSet.next() && n2 > 0) {
            arrayList.add(this.createFromResultSet(resultSet));
            --n2;
        }
        return arrayList;
    }

    public T createFromResultSet(ResultSet resultSet) throws SQLException {
        try {
            T t = this._beanClass.newInstance();
            this.hydrateFromResultSet(resultSet, t);
            Object[] objectArray = this.getPrimaryKeyColumnValues(t);
            T t2 = ((InternalSession)CurrentSession.get()).fetchFromCache(this.getBeanClass(), false, objectArray);
            if (t2 == null) {
                InternalSession internalSession = (InternalSession)CurrentSession.get();
                if (internalSession.getDirtyChecking() && this.getBeanContext().useDirtyChecking()) {
                    internalSession.merge(t);
                }
                SessionEvent sessionEvent = new SessionEvent(internalSession, t);
                for (SessionEventListener sessionEventListener : internalSession.getSessionListeners()) {
                    sessionEventListener.onLoad(sessionEvent);
                }
                if (this._addToCache) {
                    ((InternalSession)CurrentSession.get()).addToCache(t);
                }
                return t;
            }
            return t2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanBindException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new BeanBindException(instantiationException);
        }
    }

    private void hydrateFromResultSet(ResultSet resultSet, T t) throws SQLException {
        int n = 1;
        TempProp tempProp = new TempProp();
        tempProp._bean = t;
        for (TypeHandler<Object> typeHandler : this.getTypeHandlers()) {
            WProperty<Object> wProperty;
            IPropertyContext iPropertyContext = typeHandler.getPropertyContext();
            if (iPropertyContext.getReflector().hasBindableProperty()) {
                wProperty = (WProperty)iPropertyContext.getProperty(t);
            } else {
                wProperty = tempProp;
                tempProp._propertyContext = iPropertyContext;
            }
            typeHandler.loadProperty(wProperty, resultSet, n);
            if (wProperty == tempProp) {
                // empty if block
            }
            n += typeHandler.getColumns().size();
        }
    }

    public T findByPK(Session session, final Object ... objectArray) {
        return new SelectQuery<T>(this.getSelectPkQuery(), session.getConnection()){

            @Override
            protected void prepareQuery() throws SQLException {
                int n = 0;
                int n2 = 1;
                for (ColumnContext columnContext : EntityPersister.this.getPrimaryKeyColumns()) {
                    TypeHandler typeHandler = columnContext.getTypeHandler();
                    typeHandler.mapColumnToPreparedStatement(objectArray[n], columnContext.getColumnIndexInTypeHandler(), this.getStatement(), n2);
                    ++n;
                    ++n2;
                }
            }

            @Override
            protected T processRow(ResultSet resultSet) throws SQLException {
                return EntityPersister.this.createFromResultSet(resultSet);
            }
        }.getResult();
    }

    public IBeanContext getBeanContext() {
        return this._beanContext;
    }

    public Class<T> getBeanClass() {
        return this._beanClass;
    }

    public List<ColumnContext> getPrimaryKeyColumns() {
        if (this._primaryKeyColumns == null) {
            this._primaryKeyColumns = this.collectColumns(this.getPrimaryKeyHandlers());
        }
        return this._primaryKeyColumns;
    }

    public List<IPropertyContext> getPrimaryKeyContexts() {
        if (this._primaryKeyPropertyContexts == null) {
            this._primaryKeyPropertyContexts = this._sessionConfiguration.getPrimaryKeyContexts(this);
        }
        return this._primaryKeyPropertyContexts;
    }

    public List<ColumnContext> getSelectColumns() {
        return this.getColumns();
    }

    public List<ColumnContext> getInsertColumns() {
        if (this._insertColumns == null) {
            this._insertColumns = new ArrayList<ColumnContext>();
            for (ColumnContext columnContext : this.getColumns()) {
                if (columnContext.isReadOnly()) continue;
                this._insertColumns.add(columnContext);
            }
        }
        return this._insertColumns;
    }

    public List<ColumnContext> getUpdateColumns() {
        return this.getInsertColumns();
    }

    public List<ColumnContext> getColumns() {
        if (this._columns == null) {
            this._columns = this.collectColumns(this.getTypeHandlers());
        }
        return this._columns;
    }

    public List<TypeHandler<Object>> getTypeHandlers() {
        if (this._typeHandlers == null) {
            this.initPropertyContextToHandlerMap();
        }
        return this._typeHandlers;
    }

    public SessionConfiguration getSessionConfiguration() {
        return this._sessionConfiguration;
    }

    @Override
    public String getTableName() {
        if (StringX.isBlank((String)this._tableName)) {
            this._tableName = ClassX.getShortName(this.getBeanClass());
        }
        return this._tableName;
    }

    private List<ColumnContext> collectColumns(List<TypeHandler<Object>> list) {
        ArrayList<ColumnContext> arrayList = new ArrayList<ColumnContext>();
        for (TypeHandler<Object> typeHandler : list) {
            arrayList.addAll(typeHandler.getColumns());
        }
        return arrayList;
    }

    public void merge(Session session, T t, PropertyListener propertyListener) {
        if (this._beanContext.useDirtyChecking()) {
            for (TypeHandler<Object> typeHandler : this.getTypeHandlers()) {
                IPropertyContext iPropertyContext = typeHandler.getPropertyContext();
                if (!iPropertyContext.getReflector().hasBindableProperty()) continue;
                BaseProperty<?> baseProperty = iPropertyContext.getProperty(t);
                typeHandler.merge(session, baseProperty, propertyListener);
            }
        }
    }

    public void refresh(Session session, final T t, boolean bl) {
        if (bl) {
            for (IPropertyContext iPropertyContext : this.getPropertyContexts()) {
                Property property = (Property)iPropertyContext.getProperty(t);
                if (!AbstractLazyLoaderPropertyListener.isFullyLoaded(property)) continue;
                for (Object obj : Utils.getPropertyAsCollection(property)) {
                    session.refresh(obj, true);
                }
            }
        }
        new SelectQuery<Void>(this.getSelectPkQuery(), session.getConnection()){

            @Override
            protected void prepareQuery() throws SQLException {
                int n = 0;
                int n2 = 1;
                for (ColumnContext columnContext : EntityPersister.this.getPrimaryKeyColumns()) {
                    TypeHandler typeHandler = columnContext.getTypeHandler();
                    Object object = typeHandler.getColumnValue(t, n);
                    typeHandler.mapColumnToPreparedStatement(object, columnContext.getColumnIndexInTypeHandler(), this.getStatement(), n2);
                    ++n;
                    ++n2;
                }
            }

            @Override
            protected Void processRow(ResultSet resultSet) throws SQLException {
                EntityPersister.this.hydrateFromResultSet(resultSet, t);
                return null;
            }
        };
    }

    public String toString() {
        return this.getBeanClass().getName();
    }

    public List<IPropertyContext> getPropertyContexts() {
        if (this._propertyContexts == null) {
            ArrayList<IPropertyContext> arrayList = new ArrayList<IPropertyContext>();
            for (IPropertyContext iPropertyContext : this._beanContext.getProperties()) {
                if (!this._sessionConfiguration.isPersistable(iPropertyContext.getType())) continue;
                arrayList.add(iPropertyContext);
            }
            this._propertyContexts = arrayList;
        }
        return this._propertyContexts;
    }

    public void testQueries(Connection connection) {
        String[] stringArray;
        for (String string : stringArray = new String[]{this.getInsertQuery(), this.getSelectQuery(), this.getSelectPkQuery(), this.getDeleteQuery()}) {
            try {
                connection.prepareStatement(string);
            }
            catch (Exception exception) {
                this.logger.warn("error in orm generated query", (Throwable)exception);
            }
        }
    }

    public List<CascadeHandler> getCascadeHandlers() {
        if (this._cascadeHandlers == null) {
            List list = ListX.create();
            for (TypeHandler<Object> typeHandler : this.getTypeHandlers()) {
                if (!(typeHandler instanceof CascadeHandler)) continue;
                list.add((CascadeHandler)((Object)typeHandler));
            }
            this._cascadeHandlers = list;
        }
        return this._cascadeHandlers;
    }

    public TimeDuration getCacheTimeout() {
        return this.getBeanContext().getCacheTimeout();
    }

    class TempProp
    implements WProperty<Object> {
        Object _bean;
        IPropertyContext _propertyContext;

        TempProp() {
        }

        @Override
        public void set(Object object) {
            this._propertyContext.setValue(this._bean, object);
        }

        @Override
        public IPropertyContext getContext() {
            return this._propertyContext;
        }

        @Override
        public Object getParent() {
            return this._bean;
        }

        @Override
        public void setContext(IPropertyContext iPropertyContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setParent(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

