/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.SelectQuery;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.handlers.NullHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandlerFactory;
import net.model3.collections.ListX;

public class BeanQuery<T>
extends SelectQuery<T> {
    private Object[] _args;
    private Class<T> _beanClass;
    private EntityPersister<T> _persister;
    private SessionConfiguration _sessionConfiguration;

    public BeanQuery(SessionConfiguration sessionConfiguration, Class<T> clazz, String string, Object ... objectArray) {
        super(string);
        this._beanClass = clazz;
        this._args = objectArray;
        this._sessionConfiguration = sessionConfiguration;
        this._persister = this._sessionConfiguration.getPersister(this._beanClass);
        this.execute();
    }

    @Override
    protected void prepareQuery() throws SQLException {
        TypeHandlerFactory typeHandlerFactory = this._sessionConfiguration.getTypeHandlerFactory();
        if (this._args != null) {
            List list = ListX.create();
            for (Object object : this._args) {
                if (object == null) {
                    list.add(new NullHandler());
                    continue;
                }
                list.add(typeHandlerFactory.createHandlerForType(object.getClass()));
            }
            int n = 1;
            for (Object object : this._args) {
                if (object == null) {
                    int n2 = this.getStatement().getParameterMetaData().getParameterType(n);
                    this.getStatement().setNull(n, n2);
                } else {
                    ((TypeHandler)list.get(n - 1)).mapColumnToPreparedStatement(object, 0, this.getStatement(), n);
                }
                ++n;
            }
        }
    }

    @Override
    protected T processRow(ResultSet resultSet) throws SQLException {
        return this._persister.createFromResultSet(resultSet);
    }
}

