/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.java.dev.properties.jdbc.AbstractQuery;

public abstract class BatchUpdateQuery<T>
extends AbstractQuery {
    private final List<T> _beans;

    public BatchUpdateQuery(String string, List<T> list, Connection connection) {
        super(string, connection);
        this._beans = list;
    }

    @Override
    protected void runQuery() throws SQLException {
        try {
            this.getStatement().executeBatch();
            this.setQueryExecutionResponse(true);
        }
        catch (BatchUpdateException batchUpdateException) {
            if (batchUpdateException.getNextException() != null) {
                throw batchUpdateException.getNextException();
            }
            throw batchUpdateException;
        }
    }

    @Override
    protected void prepareQuery() throws SQLException {
        for (T t : this._beans) {
            this.addBeanToBatchStatement(t);
            this.getStatement().addBatch();
        }
    }

    protected abstract void addBeanToBatchStatement(T var1) throws SQLException;
}

