/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.SessionEvent;
import net.java.dev.properties.jdbc.SessionEventListener;
import net.java.dev.properties.jdbc.cache.CacheEntry;
import net.java.dev.properties.jdbc.cache.CacheEntryFetchByPk;
import net.java.dev.properties.jdbc.cache.DehydratedObject;
import net.java.dev.properties.jdbc.cache.SecondLevelCache;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.lang.ObjectX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public abstract class AbstractSession
implements InternalSession {
    static Logger logger = LoggerHelper.getLogger();
    private final Set<CacheEntryFetchByPk> _failedFetches = SetX.create();
    private final Map<CacheEntry, Object> _entityCache = new HashMap<CacheEntry, Object>();
    private IdentityHashMap<Object, Object[]> _objectToPrimaryKeyMap = new IdentityHashMap();
    @Inject
    private SessionConfiguration _sessionConfiguration;
    @Inject
    private SecondLevelCache _secondLevelCache;
    private List<SessionEventListener> _sessionListeners;

    @Override
    public void commit() {
        this.flush();
        this.commitImpl();
    }

    protected abstract void commitImpl();

    @Override
    public boolean isPersisted(Object object) {
        return this.getConfig().getPersistenceStrategy().isPersisted(this, object);
    }

    @Override
    public void insertOrUpdate(Object object) {
        if (this.isPersisted(object)) {
            this.update(object);
        } else {
            this.insert(object);
        }
    }

    @Override
    public void addListener(SessionEventListener sessionEventListener) {
        this.getSessionListeners().add(sessionEventListener);
    }

    @Override
    public SessionConfiguration getConfig() {
        return this._sessionConfiguration;
    }

    protected void setConfig(SessionConfiguration sessionConfiguration) {
        this._sessionConfiguration = sessionConfiguration;
    }

    @Override
    public SecondLevelCache getSecondLevelCache() {
        return this._secondLevelCache;
    }

    @Override
    public <T> List<T> selectAll(Class<T> clazz) {
        List<T> list = this.getSecondLevelCache().getSelectAll(clazz, this);
        if (list != null) {
            return list;
        }
        list = this.selectAllImpl(clazz);
        this.getSecondLevelCache().cacheSelectAll(clazz, list);
        return list;
    }

    @Override
    public <T> T fetchFromCache(Class<T> clazz, boolean bl, Object ... objectArray) {
        CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(clazz, objectArray);
        return this.fetchFromCache(cacheEntryFetchByPk, bl);
    }

    @Override
    public void addToCache(Object object) {
        this.addToCache(object, true);
    }

    public void addToCache(Object object, boolean bl) {
        Object[] objectArray = this.getConfig().getPersister(object.getClass()).getPrimaryKeyColumnValues(object);
        this.addToObjectToPrimaryKeyMap(object, objectArray);
        CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(object.getClass(), objectArray);
        this.addToCacheImpl(cacheEntryFetchByPk, object, bl);
    }

    protected void addToObjectToPrimaryKeyMap(Object object, Object[] objectArray) {
        this._objectToPrimaryKeyMap.put(object, objectArray);
    }

    void addToCacheImpl(CacheEntryFetchByPk cacheEntryFetchByPk, Object object, boolean bl) {
        this._entityCache.put(cacheEntryFetchByPk, object);
        if (bl) {
            cacheEntryFetchByPk.setDehydratedObject(new DehydratedObject(object, this.getConfig(), false, false));
            this.getSecondLevelCache().cacheEntity(cacheEntryFetchByPk);
        }
    }

    @Override
    public void removeFromCache(Object object) {
        if (object != null) {
            Object[] objectArray = this.getConfig().getPersister(object.getClass()).getPrimaryKeyColumnValues(object);
            this._objectToPrimaryKeyMap.remove(object);
            CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(object.getClass(), objectArray);
            this._entityCache.remove(cacheEntryFetchByPk);
        }
    }

    @Override
    public boolean cacheContains(Object object) {
        if (object != null) {
            Object[] objectArray = this.getConfig().getPersister(object.getClass()).getPrimaryKeyColumnValues(object);
            return this._entityCache.containsKey(new CacheEntryFetchByPk(this._sessionConfiguration, object));
        }
        return false;
    }

    public Object[] getPrimaryKeyValues(Object object) {
        Object[] objectArray = this._objectToPrimaryKeyMap.get(object);
        if (objectArray != null) {
            return objectArray;
        }
        return this._sessionConfiguration.getPersister(object.getClass()).getPrimaryKeyColumnValues(object);
    }

    public void setSecondLevelCache(SecondLevelCache secondLevelCache) {
        this._secondLevelCache = secondLevelCache;
    }

    protected <T> T fetchFromCache(CacheEntryFetchByPk cacheEntryFetchByPk, boolean bl) {
        Object object = this._entityCache.get(cacheEntryFetchByPk);
        if (bl && object == null && (object = ObjectX.magicast(this.getSecondLevelCache().getEntity(cacheEntryFetchByPk, this))) != null) {
            this.merge(object);
            this.addToCache(object, false);
            SessionEvent sessionEvent = new SessionEvent(this, object);
            for (SessionEventListener sessionEventListener : this.getSessionListeners()) {
                sessionEventListener.onLoad(sessionEvent);
            }
        }
        return (T)object;
    }

    public SessionConfiguration getSessionConfiguration() {
        return this._sessionConfiguration;
    }

    public boolean isCached(Object object) {
        return this._entityCache.containsKey(new CacheEntryFetchByPk(this._sessionConfiguration, object));
    }

    protected IdentityHashMap<Object, Object[]> getOjectToPrimaryKeyMap() {
        return this._objectToPrimaryKeyMap;
    }

    @Override
    public <T> T fetchByPK(Class<T> clazz, Object ... objectArray) {
        if (this.getSessionConfiguration().getNullForeignKeyChecker().isNull(clazz, objectArray)) {
            return null;
        }
        CacheEntryFetchByPk cacheEntryFetchByPk = new CacheEntryFetchByPk(clazz, objectArray);
        T t = this.fetchFromCache(cacheEntryFetchByPk, true);
        if (t == null && !this._failedFetches.contains(cacheEntryFetchByPk) && !this.getSecondLevelCache().isFailedFetch(cacheEntryFetchByPk, this)) {
            EntityPersister<T> entityPersister = this._sessionConfiguration.getPersister(clazz);
            t = this.fetchByPKImpl(entityPersister, objectArray);
            if (t == null) {
                this._failedFetches.add(cacheEntryFetchByPk);
            } else {
                this.addToCacheImpl(cacheEntryFetchByPk, t, true);
            }
        }
        return t;
    }

    protected abstract <T> T fetchByPKImpl(EntityPersister<T> var1, Object ... var2);

    @Override
    public void clear() {
        this._entityCache.clear();
        this._failedFetches.clear();
        this._objectToPrimaryKeyMap = new IdentityHashMap();
    }

    @Override
    public Object[] getPrimaryKey(Object object) {
        Object[] objectArray = this._objectToPrimaryKeyMap.get(object);
        if (objectArray == null) {
            EntityPersister<?> entityPersister = this.getConfig().getPersister(object.getClass(), true);
            objectArray = entityPersister.getPrimaryKeyColumnValues(object);
        }
        return objectArray;
    }

    @Override
    public final List<SessionEventListener> getSessionListeners() {
        if (this._sessionListeners == null) {
            this._sessionListeners = ListX.create();
            for (Class<? extends SessionEventListener> clazz : this._sessionConfiguration.getListenerClasses()) {
                try {
                    this._sessionListeners.add(clazz.newInstance());
                }
                catch (Exception exception) {
                    logger.error((Object)"error instantiating {}", (Object)clazz.getName(), (Object)exception);
                }
            }
            this._sessionListeners.addAll(this._sessionConfiguration.getListeners());
        }
        return this._sessionListeners;
    }

    public boolean isPersistable(Object object) {
        if (object == null) {
            return false;
        }
        return this.getSessionConfiguration().isPersistable(object.getClass());
    }

    @Override
    public boolean isInSession(Object object) {
        return this._objectToPrimaryKeyMap.containsKey(object);
    }

    protected abstract <T> List<T> selectAllImpl(Class<T> var1);
}

