/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.JdbcException;
import net.java.dev.properties.util.BeanPropsLoggerHelper;
import org.slf4j.Logger;

public abstract class AbstractQuery {
    private static final Logger logger = BeanPropsLoggerHelper.getLogger();
    private PreparedStatement _statement;
    private final String _sql;
    private Connection _connection;
    private Boolean _queryExecutionResponse;
    private Boolean _success;
    private Object[] _arguments;
    private boolean _manageCommiRollback;
    private boolean _closeConnection;
    private boolean _closed;

    public AbstractQuery(String string, Connection connection) {
        this._sql = string;
        this.setConnection(connection);
    }

    public void setArguments(Object ... objectArray) {
        this._arguments = objectArray;
    }

    public void setManageCommiRollback(boolean bl) {
        this._manageCommiRollback = bl;
    }

    public void setCloseConnection(boolean bl) {
        this._closeConnection = bl;
    }

    protected void closeImpl() {
        try {
            this._statement.close();
        }
        catch (Exception exception) {
            logger.warn("error cleaning up prepared statement", (Throwable)exception);
        }
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    protected void prepareQuery() throws SQLException {
        Object[] objectArray = this.getArguments();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this._statement.setObject(i + 1, objectArray[i]);
            }
        }
    }

    public void execute() {
        try {
            if (this._connection == null) {
                if (this._manageCommiRollback || this._closeConnection) {
                    throw new JdbcException("cannot use the current transactions connection and have manageCommitRollback or closeConnection true");
                }
                this._connection = CurrentSession.get().getConnection();
            }
            this._statement = this._connection.prepareStatement(this._sql);
            this.prepareQuery();
            this.runQuery();
            this.postQuery();
            this._success = true;
        }
        catch (SQLException sQLException) {
            this._success = false;
            throw new JdbcException(this._sql, sQLException);
        }
    }

    public void close() {
        if (!this._closed) {
            this._closed = true;
            try {
                this.closeImpl();
            }
            catch (Exception exception) {
                logger.warn("error closing query executor", (Throwable)exception);
            }
            if (this._manageCommiRollback) {
                if (!this._success.booleanValue()) {
                    try {
                        this.rollback();
                    }
                    catch (JdbcException jdbcException) {
                        logger.warn("error rolling back", (Throwable)jdbcException);
                    }
                } else {
                    try {
                        this.commit();
                    }
                    catch (JdbcException jdbcException) {
                        logger.warn("error committing", (Throwable)jdbcException);
                    }
                }
            }
            if (this._closeConnection) {
                try {
                    this._connection.close();
                }
                catch (Exception exception) {
                    logger.warn("error closing connection", (Throwable)exception);
                }
            }
        }
    }

    protected void rollback() {
        try {
            this._connection.rollback();
        }
        catch (Exception exception) {
            throw new JdbcException(exception);
        }
    }

    protected void commit() {
        try {
            this._connection.commit();
        }
        catch (Exception exception) {
            throw new JdbcException(exception);
        }
    }

    protected void runQuery() throws SQLException {
        boolean bl = this.getStatement().execute();
        this.setQueryExecutionResponse(bl);
    }

    protected void postQuery() throws SQLException {
    }

    public PreparedStatement getStatement() {
        return this._statement;
    }

    public String getSql() {
        return this._sql;
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setQueryExecutionResponse(Boolean bl) {
        this._queryExecutionResponse = bl;
    }

    public Boolean getSuccess() {
        return this._success;
    }
}

