/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.jdbc;

import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.events.OnGet;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.LazyLoader;

public abstract class AbstractLazyLoaderPropertyListener
implements LazyLoader,
PropertyListener {
    private OnGet _originalOnGet;
    private BaseProperty _property;
    private OnGetListener _onGetListener;
    private BeanEventManager _eventManager;
    private Object[] _primaryKeyValues;

    public AbstractLazyLoaderPropertyListener(BaseProperty baseProperty) {
        this(baseProperty, null);
    }

    public AbstractLazyLoaderPropertyListener(BaseProperty baseProperty, Object[] objectArray) {
        this._property = baseProperty;
        this._eventManager = ((HasEventManager)((Object)baseProperty)).getEventManager(true);
        this._originalOnGet = ((OnGetListener)((Object)baseProperty)).getOnGet();
        this._onGetListener = (OnGetListener)((Object)baseProperty);
        if (this._onGetListener instanceof AbstractLazyLoaderPropertyListener) {
            ((AbstractLazyLoaderPropertyListener)this._onGetListener.getOnGet()).stopListening();
        }
        this._primaryKeyValues = objectArray;
        this._onGetListener.setOnGet(this);
        this._eventManager.addListener(this);
    }

    public BeanEventManager getEventManager() {
        return this._eventManager;
    }

    public BaseProperty getProperty() {
        return this._property;
    }

    @Override
    public Object[] getPrimaryKeyValues() {
        return this._primaryKeyValues;
    }

    public void stopListening() {
        this._eventManager.removeListener(this);
        this._onGetListener.setOnGet(this._originalOnGet);
    }

    @Override
    public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
        if (n == -1) {
            this.stopListening();
        }
    }

    @Override
    public final void onGet(RProperty<?> rProperty) {
        this.stopListening();
        this.onGetImpl(rProperty);
    }

    public abstract void onGetImpl(RProperty<?> var1);

    public static Object[] getLazyPrimaryKeyValues(BaseProperty<?> baseProperty) {
        OnGet onGet = null;
        if (baseProperty instanceof OnGetListener && (onGet = ((OnGetListener)((Object)baseProperty)).getOnGet()) != null && onGet instanceof LazyLoader) {
            return ((LazyLoader)onGet).getPrimaryKeyValues();
        }
        return null;
    }

    public static boolean isFullyLoaded(BaseProperty<?> baseProperty) {
        return AbstractLazyLoaderPropertyListener.getLazyPrimaryKeyValues(baseProperty) == null;
    }
}

