/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.events;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.VetoListener;

public class VetoableChangeAdapter
implements VetoListener {
    private VetoableChangeListener listener;

    public VetoableChangeAdapter(VetoableChangeListener vetoableChangeListener) {
        this.listener = vetoableChangeListener;
    }

    public VetoableChangeListener getListener() {
        return this.listener;
    }

    @Override
    public boolean propertyChangeCheck(BaseProperty baseProperty, Object object, Object object2, int n) {
        try {
            IPropertyContext iPropertyContext = baseProperty.getContext();
            if (n > -1) {
                this.listener.vetoableChange(new IndexedPropertyChangeEvent(baseProperty.getParent(), iPropertyContext.getName(), object, object2, n));
            } else {
                this.listener.vetoableChange(new PropertyChangeEvent(baseProperty.getParent(), iPropertyContext.getName(), object, object2));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }
}

