/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.events;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.PropertyListener;

public class PropertyChangeAdapter
implements PropertyListener {
    private PropertyChangeListener listener;

    public PropertyChangeAdapter(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    @Override
    public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
        IPropertyContext iPropertyContext = baseProperty.getContext();
        if (n > -1) {
            this.listener.propertyChange(new IndexedPropertyChangeEvent(baseProperty.getParent(), iPropertyContext.getName(), object, object2, n));
        } else {
            this.listener.propertyChange(new PropertyChangeEvent(baseProperty.getParent(), iPropertyContext.getName(), object, object2));
        }
    }

    public PropertyChangeListener getListener() {
        return this.listener;
    }
}

