/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.container.AbstractReflector;
import net.model3.lang.ClassX;
import net.model3.lang.ModifierX;

public class PropertyFieldReflector
extends AbstractReflector {
    Field _field;

    public PropertyFieldReflector(Field field) {
        super(field);
        this._field = field;
        this._field.setAccessible(true);
    }

    @Override
    protected String initName() {
        return this._field.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        return this._field.getType();
    }

    @Override
    public Object getValue(Object object) {
        return ((RProperty)this.getProperty(object)).get();
    }

    @Override
    public void setValue(Object object, Object object2) {
        ((WProperty)this.getProperty(object)).set(object2);
    }

    @Override
    public Class<?> getValueType() {
        Type type = ((ParameterizedType)this._field.getGenericType()).getActualTypeArguments()[0];
        Class clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        return clazz;
    }

    @Override
    public BaseProperty<?> getProperty(Object object) {
        try {
            return (BaseProperty)this._field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException("unable to access " + this._field, exception);
        }
    }

    @Override
    public boolean isTransient() {
        return ModifierX.TRANSIENT.isIn(this._field);
    }

    @Override
    public boolean hasBindableProperty() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return ClassX.isAssignable(RProperty.class, this._field.getType());
    }

    @Override
    public boolean isWritable() {
        return ClassX.isAssignable(WProperty.class, this._field.getType());
    }

    public String toString() {
        return this._field.toString();
    }
}

