/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.annotations.Attributes;
import net.java.dev.properties.annotations.Nullable;
import net.java.dev.properties.container.BeanBindException;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.ComponentPartPropertyContext;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.OrmPropertyContext;
import net.java.dev.properties.container.Reflector;
import net.java.dev.properties.util.AbstractPropertyContext;
import net.java.dev.properties.util.Utils;
import net.model3.collections.ListX;
import net.model3.lang.StringX;

public class PropertyContext
extends AbstractPropertyContext {
    Reflector _reflector;
    boolean _transient;
    IBeanContext _parentBeanContext;
    String _name;
    String _displayName;
    Map<String, Object> _attributes;
    List<IPropertyContext> _componentPartProperties;
    BeanEventManager _eventManager = new BeanEventManager(true);
    OrmPropertyContext _ormContext;
    Class<?> _type;
    Boolean _nullable;
    IPropertyContext _super;

    public PropertyContext() {
    }

    public PropertyContext(IBeanContext iBeanContext, IPropertyContext iPropertyContext) {
        this(iBeanContext, iPropertyContext.getReflector());
        this._super = iPropertyContext;
    }

    public PropertyContext(IBeanContext iBeanContext) {
        this._parentBeanContext = iBeanContext;
    }

    public PropertyContext(IBeanContext iBeanContext, Reflector reflector) {
        this._parentBeanContext = iBeanContext;
        iBeanContext.addDeclaredProperty(this);
        this.setReflector(reflector);
        Attributes attributes = reflector.getAnnotation(Attributes.class, true);
        this.setName(StringX.getFirstNonBlank((String[])new String[]{attributes.name(), reflector.getName()}));
        this.setDisplayName(StringX.getFirstNonBlank((String[])new String[]{attributes.displayName(), Utils.prettyName(reflector.getName())}));
    }

    @Override
    public boolean isIndexedProperty() {
        Class<?> clazz = this._reflector.getPropertyType();
        return IndexedProperty.class.isAssignableFrom(clazz);
    }

    @Override
    public Class<?> getType() {
        if (this._type == null) {
            this._type = this._reflector.getValueType();
        }
        return this._type;
    }

    public void setType(Class<?> clazz) {
        this._type = clazz;
    }

    public void setReflector(Reflector reflector) {
        this._reflector = reflector;
    }

    @Override
    public IBeanContext getParentBeanContext() {
        return this._parentBeanContext;
    }

    public void setParentBeanContext(IBeanContext iBeanContext) {
        this._parentBeanContext = iBeanContext;
    }

    @Override
    public <T> T getValue(Object object) {
        return (T)this._reflector.getValue(object);
    }

    @Override
    public void setValue(Object object, Object object2) {
        this.getReflector().setValue(object, object2);
    }

    @Override
    public BaseProperty<?> getProperty(Object object) {
        try {
            return this._reflector.getProperty(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanBindException("Trying to access a property of a bean on an instance of a bean of a different type field: " + this._reflector.getName() + " on bean of: " + object.getClass().getName());
        }
    }

    @Override
    public Reflector getReflector() {
        return this._reflector;
    }

    @Override
    public boolean isNullable() {
        if (this._nullable == null) {
            this._nullable = this.getAnnotation(Nullable.class) != null;
            if (!this._nullable.booleanValue()) {
                this._nullable = PropertyContext.allowsNull(this._reflector.getAnnotations());
            }
        }
        return this._nullable;
    }

    static boolean allowsNull(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (!"Nullable".equals(clazz.getSimpleName()) && clazz != Nullable.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransient() {
        return this._reflector.isTransient();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this._reflector.getAnnotation(clazz);
    }

    @Override
    public <T> T getAttribute(String string) {
        return (T)this.getAttributes().get(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.getAttributes().put(string, object);
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        return this._attributes;
    }

    public void setComponentPartProperties(List<IPropertyContext> list) {
        this._componentPartProperties = list;
    }

    public List<IPropertyContext> getComponentPartProperties() {
        if (this.getParentBeanContext().isComponent() && this._componentPartProperties == null) {
            List list = ListX.create();
            for (IPropertyContext iPropertyContext : this.getParentBeanContext().getProperties()) {
                ComponentPartPropertyContext componentPartPropertyContext;
                if (!iPropertyContext.getParentBeanContext().isComponent() || iPropertyContext == this || (componentPartPropertyContext = (ComponentPartPropertyContext)iPropertyContext).getComponentParentProperty() != this) continue;
                list.add(componentPartPropertyContext);
            }
            this._componentPartProperties = list;
        }
        return this._componentPartProperties;
    }

    @Override
    public String getQualifiedName() {
        return this._parentBeanContext.getName() + "." + this.getName();
    }

    @Override
    public IPropertyContext getContext() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return this._reflector.isWritable();
    }

    @Override
    public boolean isReadable() {
        return this._reflector.isReadable();
    }

    @Override
    public IPropertyContext getSuper() {
        return this._super;
    }

    public void setSuper(IPropertyContext iPropertyContext) {
        this._super = iPropertyContext;
    }

    @Override
    public OrmPropertyContext getOrmContext() {
        return this._ormContext;
    }

    public void setOrmContext(OrmPropertyContext ormPropertyContext) {
        this._ormContext = ormPropertyContext;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (string.startsWith("_")) {
            string = string.substring(1);
        }
        this._name = string;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String string) {
        this._displayName = string;
    }

    @Override
    public BeanEventManager getEventManager() {
        return this._eventManager;
    }
}

