/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.util.ArrayList;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.container.PropertyContext;
import net.java.dev.properties.jdbc.handlers.TypeHandler;

public class OrmPropertyContext {
    boolean _primaryKey;
    int _compositeKeySequence = 10000;
    String[] _columnNames;
    String[] _readOnlyColumns;
    PropertyContext _propertyContext;
    Class<? extends TypeHandler> _typeHandler;
    Integer _sqlType;
    Long _length;
    Integer _decimals;

    public OrmPropertyContext(PropertyContext propertyContext) {
        this._propertyContext = propertyContext;
    }

    public void initViaColumnAnnotation(Column column, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (column.suffix().length() > 0) {
            for (String string2 : column.suffix().split(",")) {
                arrayList.add(string + string2.trim());
            }
        } else if (column.name().length() > 0) {
            arrayList = new ArrayList();
            for (String string3 : column.name().split(",")) {
                arrayList.add(string3.trim());
            }
        } else {
            arrayList.add(this._propertyContext.getName());
        }
        this.setColumnNames(arrayList.toArray(new String[arrayList.size()]));
        this.setPrimaryKey(column.key());
        this.setCompositeKeySequence(column.compositeKeySequence());
        this.setTypeHandler(column.typeHandler());
        if (column.sqlType() != Integer.MIN_VALUE) {
            this.setSqlType(column.sqlType());
        }
        if (column.length() >= 0L) {
            this.setLength(column.length());
        }
        if (column.decimals() >= 0) {
            this.setDecimals(column.decimals());
        }
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public int getCompositeKeySequence() {
        return this._compositeKeySequence;
    }

    public PropertyContext getPropertyContext() {
        return this._propertyContext;
    }

    public void setColumnNames(String[] stringArray) {
        this._columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public String getColumnName() {
        return this._columnNames[0];
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this._typeHandler;
    }

    public void setTypeHandler(Class<? extends TypeHandler> clazz) {
        if (clazz != null && !clazz.equals(TypeHandler.class)) {
            this._typeHandler = clazz;
        }
    }

    public String[] getReadOnlyColumns() {
        if (this._readOnlyColumns == null) {
            this._readOnlyColumns = new String[0];
        }
        return this._readOnlyColumns;
    }

    public void setReadOnlyColumns(String string) {
        this._readOnlyColumns = string.split(",");
        for (int i = 0; i < this._readOnlyColumns.length; ++i) {
            this._readOnlyColumns[i] = this._readOnlyColumns[i].trim();
        }
    }

    public void setPrimaryKey(boolean bl) {
        this._primaryKey = bl;
    }

    public void setColumnName(String string) {
        this._columnNames = new String[]{string};
    }

    public void setCompositeKeySequence(int n) {
        this._compositeKeySequence = n;
    }

    public Integer getSqlType() {
        return this._sqlType;
    }

    public void setSqlType(Integer n) {
        this._sqlType = n;
    }

    public Long getLength() {
        return this._length;
    }

    public void setLength(Integer n) {
        this.setLength(n.longValue());
    }

    public void setLength(Long l) {
        if (l < 0L) {
            throw new RuntimeException("cannot set length to " + l + " on " + this.getPropertyContext() + " this is tom foolery you don't want to do this");
        }
        this._length = l;
    }

    public Integer getDecimals() {
        return this._decimals;
    }

    public void setDecimals(Integer n) {
        this._decimals = n;
    }
}

