/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.java.dev.properties.IndexedPropertyImpl;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.events.OnGet;
import net.java.dev.properties.events.OnGetListener;

public class ObservableIndexed<T>
extends IndexedPropertyImpl<T>
implements HasEventManager,
OnGetListener {
    private static final long serialVersionUID = -3613266699948030320L;
    private OnGet onGet;
    BeanEventManager _eventManager;

    public ObservableIndexed() {
        super(true);
        this.doSetQuietly(null);
    }

    public ObservableIndexed(Collection<T> collection) {
        super(true);
        this.doSetQuietly(collection);
    }

    public ObservableIndexed(T ... TArray) {
        super(true);
        this.doSetQuietly(null);
        for (T t : TArray) {
            this.add(t);
        }
    }

    public static <K> ObservableIndexed<K> create() {
        return new ObservableIndexed();
    }

    public static <K> ObservableIndexed<K> create(Collection<K> collection) {
        return new ObservableIndexed<K>(collection);
    }

    public static <K> ObservableIndexed<K> create(K ... KArray) {
        return new ObservableIndexed<K>(KArray);
    }

    protected T doSet(int n, T t) {
        T t2 = this.doGetImpl().set(n, t);
        BeanContainer.get().firePropertyChanged(this, this.getContext(), this.getParent(), t2, t, n);
        return t2;
    }

    protected void doAdd(int n, T t) {
        this.doGetImpl().add(n, t);
        BeanContainer.get().fireOnInsert(this, this.getContext(), this.getParent(), t, n);
    }

    protected void doAdd(T t) {
        List<T> list = this.doGetImpl();
        list.add(t);
        BeanContainer.get().fireOnInsert(this, this.getContext(), this.getParent(), t, list.size() - 1);
    }

    protected boolean doRemove(Object object) {
        List<T> list = this.doGetImpl();
        int n = list.indexOf(object);
        if (n != -1) {
            T t = list.remove(n);
            BeanContainer.get().fireOnRemove(this, this.getContext(), this.getParent(), t, n);
            return true;
        }
        return false;
    }

    protected T doRemove(int n) {
        List<T> list = this.doGetImpl();
        T t = list.remove(n);
        BeanContainer.get().fireOnRemove(this, this.getContext(), this.getParent(), t, n);
        return t;
    }

    @Override
    public void set(List<T> list) {
        this.doSet(list);
    }

    protected void doSet(Collection<T> collection) {
        Object object = super.get();
        List<T> list = this.doSetQuietly(collection);
        BeanContainer.get().firePropertyChanged(this, this.getContext(), this.getParent(), object, list, -1);
    }

    protected List<T> doSetQuietly(Collection<T> collection) {
        ListWrapper listWrapper = new ListWrapper(this, collection);
        super.doSet(listWrapper, false);
        return listWrapper;
    }

    @Override
    public void setOnGet(OnGet onGet) {
        this.onGet = onGet;
    }

    @Override
    public OnGet getOnGet() {
        return this.onGet;
    }

    protected ListWrapper<T> doGetWrapper() {
        return (ListWrapper)this.get();
    }

    private final void callOnGet() {
        if (this.onGet != null) {
            this.onGet.onGet(this);
        }
    }

    @Override
    public List<T> get() {
        this.callOnGet();
        return super.get();
    }

    protected List<T> doGetImpl() {
        return ((ListWrapper)this.doGetWrapper())._impl;
    }

    @Override
    public BeanEventManager getEventManager() {
        return this.getEventManager(true);
    }

    @Override
    public BeanEventManager getEventManager(boolean bl) {
        if (this._eventManager == null && bl) {
            this._eventManager = new BeanEventManager();
        }
        return this._eventManager;
    }

    private static class ListWrapper<T>
    extends AbstractList<T>
    implements Serializable {
        private static final long serialVersionUID = -4066625422157366747L;
        private final List<T> _impl = new ArrayList<T>();
        private final ObservableIndexed<T> _parent;

        private ListWrapper(ObservableIndexed<T> observableIndexed) {
            this._parent = observableIndexed;
        }

        private ListWrapper(ObservableIndexed<T> observableIndexed, Collection<T> collection) {
            this(observableIndexed);
            if (collection != null) {
                this._impl.addAll(collection);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this._impl.iterator();
        }

        @Override
        public int size() {
            return this._impl.size();
        }

        @Override
        public void add(int n, T t) {
            this._parent.doAdd(n, t);
        }

        @Override
        public T get(int n) {
            return this._impl.get(n);
        }

        @Override
        public int indexOf(Object object) {
            return this._impl.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this._impl.lastIndexOf(object);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this._impl.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int n) {
            return this._impl.listIterator(n);
        }

        @Override
        public boolean remove(Object object) {
            return this._parent.doRemove(object);
        }

        @Override
        public T remove(int n) {
            return this._parent.remove(n);
        }

        @Override
        public T set(int n, T t) {
            return this._parent.set(n, t);
        }

        @Override
        public List<T> subList(int n, int n2) {
            throw new RuntimeException("implement me");
        }
    }
}

