/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.java.dev.properties.events.PropertyChangeAdapter;
import net.java.dev.properties.events.VetoableChangeAdapter;

public class ObservableDelegate<T>
implements Serializable {
    private List<T> listeners;

    public List<T> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<T> list) {
        this.listeners = list;
    }

    public synchronized void addListener(T t) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<T>();
            this.listeners.add(t);
            return;
        }
        if (!this.listeners.contains(t)) {
            this.listeners.add(t);
        }
    }

    public synchronized void removeListener(T t) {
        List<T> list = this.listeners;
        if (list != null && list.size() > 0) {
            list.remove(t);
            if (list.size() == 0) {
                list = null;
            }
        }
    }

    public void removeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            for (T t : this.listeners) {
                if (!(t instanceof PropertyChangeAdapter) || ((PropertyChangeAdapter)t).getListener() != propertyChangeListener) continue;
                this.listeners.remove(t);
                return;
            }
        }
    }

    public void removeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.listeners != null) {
            for (T t : this.listeners) {
                if (!(t instanceof VetoableChangeAdapter) || ((VetoableChangeAdapter)t).getListener() != vetoableChangeListener) continue;
                this.listeners.remove(t);
                return;
            }
        }
    }
}

