/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.lang.reflect.Method;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.container.AbstractReflector;
import net.model3.lang.NotImplementedException;

public class MethodReflector
extends AbstractReflector {
    static final String[] prefixes = new String[]{"is", "has", "get"};
    Method _getterMethod;
    Method _setterMethod;

    public MethodReflector(Method method, Method method2) {
        super(method);
        this._getterMethod = method;
        this._setterMethod = method2;
    }

    public MethodReflector(Method method) {
        super(method);
        this._getterMethod = method;
    }

    @Override
    protected String initName() {
        String string = this._getterMethod.getName();
        for (String string2 : prefixes) {
            if (!string.startsWith(string2) || string.length() <= string2.length()) continue;
            string = string.substring(string2.length(), string2.length() + 1).toLowerCase() + string.substring(string2.length() + 1);
            break;
        }
        return string;
    }

    @Override
    public BaseProperty<?> getProperty(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Class<?> getValueType() {
        return this._getterMethod.getReturnType();
    }

    @Override
    public Class<?> getPropertyType() {
        if (this._getterMethod != null) {
            return this._getterMethod.getReturnType();
        }
        return this._setterMethod.getParameterTypes()[0];
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this._getterMethod.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            throw new RuntimeException("error accessing method " + this._getterMethod + " on bean " + object, exception);
        }
    }

    @Override
    public void setValue(Object object, Object object2) {
        if (this._setterMethod != null) {
            try {
                this._setterMethod.invoke(object, object2);
            }
            catch (Exception exception) {
                throw new RuntimeException("error accessing method " + this._setterMethod + " on bean " + object, exception);
            }
        } else {
            throw new RuntimeException("no setter method provided");
        }
    }

    @Override
    public boolean hasBindableProperty() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }
}

