/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.util.Set;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.container.BeanBindException;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.events.OnGetListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.jdbc.LazyLoader;
import net.model3.collections.SetX;

public class BidiAssociationHandler
implements PropertyListener {
    ThreadLocal<Set<BaseProperty>> _lockStack = new ThreadLocal<Set<BaseProperty>>(){

        @Override
        protected Set<BaseProperty> initialValue() {
            return SetX.create();
        }
    };
    IPropertyContext _localPropertyContext;
    BidiAssociationHandler _foreignBidiAssocation;
    IPropertyContext _foreignPropertyContext;

    BidiAssociationHandler(IPropertyContext iPropertyContext) {
        this._localPropertyContext = iPropertyContext;
        this._localPropertyContext.setAttribute(BidiAssociationHandler.class.getName(), this);
        this._localPropertyContext.getEventManager().addListener(this);
    }

    public IPropertyContext getForeignPropertyContext() {
        if (this._foreignPropertyContext == null) {
            this._foreignPropertyContext = BidiAssociationHandler.getForeignPropertyContext(this._localPropertyContext);
        }
        return this._foreignPropertyContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
        BaseProperty<?> baseProperty2;
        if (object == object2) {
            boolean bl = true;
            if (object == null && (baseProperty2 = ((OnGetListener)((Object)baseProperty)).getOnGet()) instanceof LazyLoader) {
                bl = false;
                object = ((RProperty)baseProperty).get();
            }
            if (bl) {
                return;
            }
        }
        if (!this._lockStack.get().contains(baseProperty)) {
            try {
                this._lockStack.get().add(baseProperty);
                Object object3 = baseProperty.getParent();
                if (object != null) {
                    this.disassociate(baseProperty, object);
                    baseProperty2 = this.getForeignPropertyContext().getProperty(object);
                    if (baseProperty2 != null) {
                        this.getForeignBidiAssocation().disassociate(baseProperty2, object3);
                    }
                }
                this.associate(baseProperty, object2);
                if (object2 != null && (baseProperty2 = this.getForeignPropertyContext().getProperty(object2)) != null) {
                    this.getForeignBidiAssocation().associate(baseProperty2, object3);
                }
            }
            finally {
                this._lockStack.get().remove(baseProperty);
            }
        }
    }

    public BidiAssociationHandler getForeignBidiAssocation() {
        if (this._foreignBidiAssocation == null) {
            this._foreignBidiAssocation = (BidiAssociationHandler)this.getForeignPropertyContext().getAttribute(BidiAssociationHandler.class.getName());
        }
        return this._foreignBidiAssocation;
    }

    protected void associate(BaseProperty<?> baseProperty, Object object) {
        Object t = ((RProperty)baseProperty).get();
        if (t != null) {
            if (!this.getForeignPropertyContext().isIndexedProperty()) {
                this.getForeignPropertyContext().setValue(t, null);
            }
            this.disassociate(baseProperty, t);
        }
        if (object != null) {
            ((WProperty)baseProperty).set(object);
        }
    }

    protected void disassociate(BaseProperty<?> baseProperty, Object object) {
        ((WProperty)baseProperty).set(null);
    }

    public static IPropertyContext getForeignPropertyContext(IPropertyContext iPropertyContext) {
        String string = "ForeignPropertyContext";
        IPropertyContext iPropertyContext2 = (IPropertyContext)iPropertyContext.getAttribute(string);
        if (iPropertyContext2 != null) {
            return iPropertyContext2;
        }
        Class<?> clazz = iPropertyContext.getType();
        Bidirectional bidirectional = iPropertyContext.getAnnotation(Bidirectional.class);
        if (bidirectional == null) {
            throw new RuntimeException("no associated bidi found for " + iPropertyContext);
        }
        String string2 = iPropertyContext.getAnnotation(Bidirectional.class).value();
        IBeanContext iBeanContext = BeanContainer.get().getContext(clazz);
        for (IPropertyContext iPropertyContext3 : iBeanContext.getProperties()) {
            Bidirectional bidirectional2 = iPropertyContext3.getAnnotation(Bidirectional.class);
            if (bidirectional2 == null || !bidirectional2.value().equals(string2)) continue;
            iPropertyContext.setAttribute(string, iPropertyContext3);
            return iPropertyContext3;
        }
        throw new BeanBindException("no @Bidirectional " + string2 + " found in " + clazz.getName());
    }
}

