/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.annotations.Bean;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.BeanContextToolChain;
import net.java.dev.properties.container.BidiAssociationHandler;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.IndexedBidiAssociationHandler;
import net.java.dev.properties.container.PropertyContext;
import net.java.dev.properties.container.PropertyFieldReflector;
import net.java.dev.properties.util.Utils;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class BeanPropertiesInjector
implements BeanContextToolChain {
    private static final Logger logger = LoggerHelper.getLogger();

    @Override
    public void contextCreated(BeanContainer beanContainer, BeanContext beanContext) {
        Class<?> clazz = beanContext.getType();
        Bean bean = (Bean)ClassX.getAnnotation(clazz, Bean.class, (boolean)true);
        beanContext.setName(clazz.getName());
        beanContext.setDisplayName(StringX.getFirstNonBlank((String[])new String[]{bean.displayName(), Utils.prettyName(ClassX.getShortName(clazz))}));
        beanContext.setTypeHandler(bean.typeHandler());
        beanContext.setComponent(bean.component());
        beanContext.setType(clazz);
        Table table = (Table)ClassX.getAnnotation(clazz, Table.class, (boolean)true);
        beanContext.setTableName(StringX.getFirstNonBlank((String[])new String[]{table.name(), ClassX.getShortName(clazz)}));
        beanContext.setTablePrefix(table.prefix());
        beanContext.setUseDirtyChecking(table.useDirtyChecking());
        if (StringX.isNotBlank((String)table.cacheTimeout())) {
            beanContext.setCacheTimeout(new TimeDuration(table.cacheTimeout()));
        }
        ArrayList arrayList = new ArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            if (!this.isProperty(field)) continue;
            field.setAccessible(true);
            beanContainer.initializePropertyContext(new PropertyContext((IBeanContext)beanContext, new PropertyFieldReflector(field)));
        }
        for (IPropertyContext iPropertyContext : beanContext.getBidiProperties()) {
            if (iPropertyContext.isIndexedProperty()) {
                new IndexedBidiAssociationHandler(iPropertyContext);
                continue;
            }
            new BidiAssociationHandler(iPropertyContext);
        }
    }

    private boolean isProperty(Field field) {
        int n = field.getModifiers();
        if (BaseProperty.class.isAssignableFrom(field.getType())) {
            if (!Modifier.isFinal(n)) {
                logger.warn((Object)"Properties MUST be declared final! Make sure to fix {}", (Object)field);
            }
            return !Modifier.isStatic(n);
        }
        return false;
    }
}

