/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContext;
import net.java.dev.properties.events.BindListener;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.ClassX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public final class BeanContext
implements IBeanContext {
    private static final Logger logger = LoggerHelper.getLogger();
    List<IPropertyContext> _declaredProperties = ListX.create();
    List<IBeanContext> _children = ListX.create();
    List<IPropertyContext> _derivedProperties;
    Map<String, IPropertyContext> _derivedPropertiesMap;
    IBeanContext _super;
    String _tableName;
    String _tablePrefix;
    boolean _component;
    BeanEventManager _eventManager = new BeanEventManager(true);
    List<BindListener> _bindListeners;
    Class<? extends TypeHandler> _typeHandler;
    Class<?> _type;
    List<IPropertyContext> _bidiProperties;
    Map<String, Object> _attributes = MapX.create();
    BeanContainer _beanContainer;
    String _name;
    String _displayName;
    Object _defaultValue;
    boolean _useDirtyChecking = true;
    TimeDuration _cacheTimeout;

    BeanContext(BeanContainer beanContainer) {
        this._beanContainer = beanContainer;
    }

    @Override
    public <T> T newInstance() {
        return (T)ClassX.newInstance(this._type);
    }

    @Override
    public <T> T getAttribute(String string) {
        return (T)this._attributes.get(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    public void setType(Class<?> clazz) {
        this._type = clazz;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public List<IPropertyContext> getBidiProperties() {
        if (this._bidiProperties == null) {
            ArrayList<IPropertyContext> arrayList = new ArrayList<IPropertyContext>();
            for (IPropertyContext iPropertyContext : this.getProperties()) {
                if (iPropertyContext.getAnnotation(Bidirectional.class) == null) continue;
                arrayList.add(iPropertyContext);
            }
            this._bidiProperties = arrayList;
        }
        return this._bidiProperties;
    }

    Map<String, IPropertyContext> getPropertiesMap() {
        if (this._derivedPropertiesMap == null) {
            LinkedHashMap<String, IPropertyContext> linkedHashMap = new LinkedHashMap<String, IPropertyContext>();
            if (this.getSuper() != null) {
                for (IPropertyContext iPropertyContext : this.getSuper().getProperties()) {
                    PropertyContext propertyContext = new PropertyContext((IBeanContext)this, iPropertyContext);
                    BeanContainer.get().initializePropertyContext(propertyContext);
                    linkedHashMap.put(propertyContext.getName(), propertyContext);
                }
            }
            for (IPropertyContext iPropertyContext : this.getDeclaredProperties()) {
                linkedHashMap.put(iPropertyContext.getName(), iPropertyContext);
            }
            this._derivedPropertiesMap = linkedHashMap;
        }
        return this._derivedPropertiesMap;
    }

    @Override
    public List<IPropertyContext> getProperties() {
        if (this._derivedProperties == null) {
            this._derivedProperties = ListX.create(this.getPropertiesMap().values());
        }
        return this._derivedProperties;
    }

    private List<IPropertyContext> getDeclaredProperties() {
        return this._declaredProperties;
    }

    @Override
    public IPropertyContext getProperty(String string) {
        IPropertyContext iPropertyContext = this.getPropertiesMap().get(string);
        if (iPropertyContext != null) {
            return iPropertyContext;
        }
        if (this.getSuper() != null) {
            return this.getSuper().getProperty(string);
        }
        return null;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    void setTableName(String string) {
        this._tableName = string;
    }

    @Override
    public String getTablePrefix() {
        return this._tablePrefix;
    }

    void setTablePrefix(String string) {
        this._tablePrefix = string;
    }

    @Override
    public void addBindListener(BindListener bindListener) {
        if (this._bindListeners == null) {
            this._bindListeners = new CopyOnWriteArrayList<BindListener>();
        }
        this._bindListeners.add(bindListener);
    }

    public void removeBindListener(BindListener bindListener) {
        this._bindListeners.remove(bindListener);
    }

    @Override
    public void fireBindEvent(Object object) {
        if (this._bindListeners != null) {
            for (BindListener bindListener : this._bindListeners) {
                bindListener.beanBound(object, this);
            }
        }
    }

    @Override
    public Class<? extends TypeHandler> getTypeHandler() {
        return this._typeHandler;
    }

    public void setTypeHandler(Class<? extends TypeHandler> clazz) {
        if (!clazz.equals(TypeHandler.class)) {
            this._typeHandler = clazz;
        }
    }

    public void setComponent(boolean bl) {
        this._component = bl;
    }

    @Override
    public boolean isComponent() {
        return this._component;
    }

    public String toString() {
        return this.getType().getName();
    }

    @Override
    public IBeanContext getSuper() {
        if (this._super == null && !this._type.equals(Object.class) && this.getType().getSuperclass() != null) {
            this._super = BeanContainer.get().getContext(this.getType().getSuperclass());
            this._super.addChild(this);
        }
        return this._super;
    }

    @Override
    public void addDeclaredProperty(IPropertyContext iPropertyContext) {
        if (!this._declaredProperties.contains(iPropertyContext)) {
            this._declaredProperties.add(iPropertyContext);
            if (iPropertyContext instanceof PropertyContext) {
                ((PropertyContext)iPropertyContext).setParentBeanContext(this);
            }
            this.resetDerivedValues();
        }
    }

    private void resetDerivedValues() {
        this._derivedProperties = null;
        this._derivedPropertiesMap = null;
        for (IBeanContext iBeanContext : ListX.create(this._children)) {
            if (!(iBeanContext instanceof BeanContext)) continue;
            ((BeanContext)iBeanContext).resetDerivedValues();
        }
    }

    public void setName(String string) {
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String string) {
        this._displayName = string;
    }

    @Override
    public BeanEventManager getEventManager() {
        return this._eventManager;
    }

    @Override
    public void addChild(IBeanContext iBeanContext) {
        if (!this._children.contains(iBeanContext)) {
            this._children.add(iBeanContext);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._type == null ? 0 : this._type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BeanContext beanContext = (BeanContext)object;
        return !(this._type == null ? beanContext._type != null : !this._type.equals(beanContext._type));
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public void setDefaultValue(Object object) {
        this._defaultValue = object;
    }

    void setUseDirtyChecking(boolean bl) {
        this._useDirtyChecking = bl;
    }

    @Override
    public boolean useDirtyChecking() {
        return this._useDirtyChecking;
    }

    @Override
    public TimeDuration getCacheTimeout() {
        return this._cacheTimeout;
    }

    public void setCacheTimeout(TimeDuration timeDuration) {
        this._cacheTimeout = timeDuration;
    }
}

