/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.container;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.container.BeanBindException;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.BeanContextToolChain;
import net.java.dev.properties.container.BeanPropertiesInjector;
import net.java.dev.properties.container.ChainedReflector;
import net.java.dev.properties.container.ComponentPartPropertyContext;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.OrmPropertyContext;
import net.java.dev.properties.container.PropertyContext;
import net.java.dev.properties.container.Reflector;
import net.java.dev.properties.container.VirtualPropertyInjector;
import net.java.dev.properties.events.IndexedPropertyListener;
import net.java.dev.properties.events.PropertyListener;
import net.java.dev.properties.util.Utils;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class BeanContainer {
    private static final Logger logger = LoggerHelper.getLogger();
    private static BeanContainer instance = null;
    final Map<Class, IBeanContext> _contextMap = Collections.synchronizedMap(new HashMap());
    final Set<Class> _failedContextInitialization = Collections.synchronizedSet(new HashSet());
    final List<BeanContextToolChain> _beanContextToolChain = ListX.create();
    ThreadLocal<Boolean> _suppressEventsThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    @Inject
    public BeanContainer() {
        this._beanContextToolChain.add(new BeanPropertiesInjector());
        this._beanContextToolChain.add(new VirtualPropertyInjector());
    }

    public static BeanContainer get() {
        if (instance == null) {
            instance = (BeanContainer)DependencyInjector.getInstance(BeanContainer.class);
        }
        return instance;
    }

    public void addBeanContextToolChain(BeanContextToolChain beanContextToolChain) {
        this._beanContextToolChain.add(beanContextToolChain);
    }

    public static void set(BeanContainer beanContainer) {
        if (BeanContainer.instance._contextMap.size() > 0) {
            logger.warn((Object)"Beans were already bound to this container! See: {}", BeanContainer.instance._contextMap.keySet(), (Object)new Throwable());
        }
        instance = beanContainer;
    }

    public IBeanContext bindBean(Object object) {
        try {
            IBeanContext iBeanContext = this.getContext(object.getClass());
            for (IPropertyContext iPropertyContext : iBeanContext.getProperties()) {
                BaseProperty<?> baseProperty;
                Reflector reflector = iPropertyContext.getReflector();
                if (reflector == null || !reflector.hasBindableProperty() || (baseProperty = reflector.getProperty(object)) == null) continue;
                baseProperty.setContext(iPropertyContext);
                baseProperty.setParent(object);
            }
            iBeanContext.fireBindEvent(object);
            return iBeanContext;
        }
        catch (AccessControlException accessControlException) {
            JOptionPane.showMessageDialog(null, "Due to a bug in Java 5 bean properties cannot work\nproperly at this time in an untrusted environment.\nYou can either upgrade to Java 6 or download the application\nand run it locally", "Error", 0);
            throw new BeanBindException(accessControlException);
        }
    }

    private BeanContext createBeanContext(Class<?> clazz) {
        BeanContext beanContext = new BeanContext(this);
        this._contextMap.put(clazz, beanContext);
        beanContext.setType(clazz);
        beanContext.setName(clazz.getName());
        beanContext.setDisplayName(Utils.prettyName(ClassX.getShortName(clazz)));
        for (BeanContextToolChain beanContextToolChain : this._beanContextToolChain) {
            beanContextToolChain.contextCreated(this, beanContext);
        }
        return beanContext;
    }

    public static void bind(Object object) {
        BeanContainer.get().bindBean(object);
    }

    public IBeanContext getContext(Class clazz) {
        IBeanContext iBeanContext = this._contextMap.get(clazz);
        if (iBeanContext == null && !this._failedContextInitialization.contains(clazz)) {
            try {
                iBeanContext = this.createBeanContext(clazz);
            }
            catch (Exception exception) {
                logger.debug((Object)"failed to create bean context for {}", (Object)clazz, (Object)exception);
            }
            if (iBeanContext == null) {
                this._failedContextInitialization.add(clazz);
            }
        }
        return iBeanContext;
    }

    public IBeanContext getContext(Object object) {
        if (object == null) {
            return null;
        }
        return this.getContext(object.getClass());
    }

    private boolean isProperty(Field field) {
        int n = field.getModifiers();
        if (BaseProperty.class.isAssignableFrom(field.getType())) {
            if (!Modifier.isFinal(n)) {
                throw new BeanBindException("Properties MUST be declared final! Make sure to fix " + field.getName() + " from: " + field.getDeclaringClass().getName());
            }
            return !Modifier.isStatic(n);
        }
        return false;
    }

    void fireOnRemove(final IndexedProperty indexedProperty, IPropertyContext iPropertyContext, Object object, final Object object2, final int n) {
        if (this.areEventsSuppressed()) {
            return;
        }
        this.fireIndexEvent(indexedProperty, iPropertyContext, object, object2, n, new Visitor<PropertyListener>(){

            public void visit(PropertyListener propertyListener) {
                if (propertyListener instanceof IndexedPropertyListener) {
                    ((IndexedPropertyListener)propertyListener).propertyRemoved(indexedProperty, object2, n);
                }
            }
        });
    }

    public void fireOnInsert(final IndexedProperty indexedProperty, IPropertyContext iPropertyContext, Object object, final Object object2, final int n) {
        if (this.areEventsSuppressed()) {
            return;
        }
        this.fireIndexEvent(indexedProperty, iPropertyContext, object, object2, n, new Visitor<PropertyListener>(){

            public void visit(PropertyListener propertyListener) {
                if (propertyListener instanceof IndexedPropertyListener) {
                    ((IndexedPropertyListener)propertyListener).propertyInserted(indexedProperty, object2, n);
                }
            }
        });
    }

    private void fireIndexEvent(IndexedProperty indexedProperty, IPropertyContext iPropertyContext, Object object, Object object2, int n, Visitor<PropertyListener> visitor) {
        if (this.areEventsSuppressed()) {
            return;
        }
        if (indexedProperty instanceof HasEventManager && ((HasEventManager)((Object)indexedProperty)).getEventManager() != null) {
            ((HasEventManager)((Object)indexedProperty)).getEventManager().visitListeners(visitor);
        }
        iPropertyContext.getEventManager().visitListeners(visitor);
        if (object instanceof HasEventManager && ((HasEventManager)object).getEventManager(false) != null) {
            ((HasEventManager)object).getEventManager().visitListeners(visitor);
        }
        iPropertyContext.getEventManager().visitListeners(visitor);
    }

    private boolean areEventsSuppressed() {
        return this._suppressEventsThreadLocal.get();
    }

    void firePropertyChanged(final BaseProperty baseProperty, IPropertyContext iPropertyContext, Object object, final Object object2, final Object object3, final int n) {
        if (this.areEventsSuppressed()) {
            return;
        }
        Visitor<PropertyListener> visitor = new Visitor<PropertyListener>(){

            public void visit(PropertyListener propertyListener) {
                propertyListener.propertyChanged(baseProperty, object2, object3, n);
            }
        };
        if (baseProperty instanceof HasEventManager && ((HasEventManager)((Object)baseProperty)).getEventManager(false) != null) {
            ((HasEventManager)((Object)baseProperty)).getEventManager().visitListeners(visitor);
        }
        iPropertyContext.getEventManager().visitListeners(visitor);
        if (object instanceof HasEventManager) {
            ((HasEventManager)object).getEventManager().visitListeners(visitor);
        }
        iPropertyContext.getParentBeanContext().getEventManager().visitListeners(visitor);
    }

    public void initializePropertyContext(PropertyContext propertyContext) {
        IBeanContext iBeanContext = propertyContext.getParentBeanContext();
        String string = iBeanContext.getTablePrefix();
        OrmPropertyContext ormPropertyContext = new OrmPropertyContext(propertyContext);
        Column column = propertyContext.getAnnotation(Column.class);
        if (column != null) {
            ormPropertyContext.initViaColumnAnnotation(column, string);
        } else {
            ormPropertyContext.setColumnName(propertyContext.getName());
        }
        propertyContext.setOrmContext(ormPropertyContext);
        IBeanContext iBeanContext2 = this.getContext(propertyContext.getType());
        if (iBeanContext2 != null && iBeanContext2.isComponent()) {
            List list = ListX.create();
            propertyContext.setComponentPartProperties(list);
            for (IPropertyContext iPropertyContext : iBeanContext2.getProperties()) {
                OrmPropertyContext ormPropertyContext2 = iPropertyContext.getOrmContext();
                ComponentPartPropertyContext componentPartPropertyContext = new ComponentPartPropertyContext(propertyContext, iPropertyContext);
                list.add(componentPartPropertyContext);
                String string2 = propertyContext.getName() + iPropertyContext.getName().substring(0, 1).toUpperCase() + iPropertyContext.getName().substring(1);
                String string3 = ormPropertyContext.getColumnName() + ormPropertyContext2.getColumnName().substring(0, 1).toUpperCase() + ormPropertyContext2.getColumnName().substring(1);
                OrmPropertyContext ormPropertyContext3 = new OrmPropertyContext(componentPartPropertyContext);
                componentPartPropertyContext.setName(string2);
                ormPropertyContext3.setColumnName(string3);
                componentPartPropertyContext.setOrmContext(ormPropertyContext3);
                componentPartPropertyContext.setDisplayName(iPropertyContext.getDisplayName());
                componentPartPropertyContext.setReflector(new ChainedReflector(propertyContext.getReflector(), iPropertyContext.getReflector()));
                ormPropertyContext3.setTypeHandler(ormPropertyContext2.getTypeHandler());
            }
        }
        if (propertyContext.getTypeAsBeanContext().isComponent()) {
            for (IPropertyContext iPropertyContext : propertyContext.getComponentPartProperties()) {
                propertyContext.getParentBeanContext().addDeclaredProperty(iPropertyContext);
            }
        }
    }

    public void doWithEventSuppression(Runnable runnable) {
        boolean bl = this._suppressEventsThreadLocal.get();
        try {
            this._suppressEventsThreadLocal.set(true);
            runnable.run();
        }
        finally {
            this._suppressEventsThreadLocal.set(bl);
        }
    }
}

